/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.UnsupportedMessageTypeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$StreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$ConnectionListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$FrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$Http2RemoteFlowControllerListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2PingFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ResetFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2SettingsFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2UnknownFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    protected final Http2Connection$PropertyKey streamKey;
    private final Http2Connection$PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<Http2FrameCodec$DefaultHttp2FrameStream> frameStreamToInitializeMap = new IntObjectHashMap<Http2FrameCodec$DefaultHttp2FrameStream>(8);
    private final ChannelFutureListener bufferedStreamsListener = new Http2FrameCodec$1(this);

    Http2FrameCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, boolean bl3) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl3);
        http2ConnectionDecoder.frameListener(new Http2FrameCodec$FrameListener(this, null));
        this.connection().addListener(new Http2FrameCodec$ConnectionListener(this, null));
        this.connection().remote().flowController().listener(new Http2FrameCodec$Http2RemoteFlowControllerListener(this, null));
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = http2Settings.initialWindowSize();
    }

    Http2FrameCodec$DefaultHttp2FrameStream newStream() {
        return new Http2FrameCodec$DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(Http2FrameStreamVisitor http2FrameStreamVisitor) {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            this.connection().forEachActiveStream(new Http2FrameCodec$2(this, http2FrameStreamVisitor));
        }
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
        this.handlerAdded0(channelHandlerContext);
        Http2Connection http2Connection = this.connection();
        if (http2Connection.isServer()) {
            this.tryExpandConnectionFlowControlWindow(http2Connection);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection http2Connection) {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream http2Stream = http2Connection.connectionStream();
            Http2LocalFlowController http2LocalFlowController = http2Connection.local().flowController();
            int n4 = this.initialFlowControlWindowSize - http2LocalFlowController.initialWindowSize(http2Stream);
            if (n4 > 0) {
                http2LocalFlowController.incrementWindowSize(http2Stream, Math.max(n4 << 1, n4));
                this.flush(this.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            this.tryExpandConnectionFlowControlWindow(this.connection());
        } else if (object instanceof HttpServerUpgradeHandler$UpgradeEvent) {
            HttpServerUpgradeHandler$UpgradeEvent httpServerUpgradeHandler$UpgradeEvent = (HttpServerUpgradeHandler$UpgradeEvent)object;
            try {
                this.onUpgradeEvent(channelHandlerContext, httpServerUpgradeHandler$UpgradeEvent.retain());
                Http2Stream http2Stream = this.connection().stream(1);
                if (http2Stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(http2Stream);
                }
                httpServerUpgradeHandler$UpgradeEvent.upgradeRequest().headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_ID.text(), 1);
                http2Stream.setProperty(this.upgradeKey, true);
                InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection(), this.decoder().frameListener(), httpServerUpgradeHandler$UpgradeEvent.upgradeRequest().retain());
            }
            finally {
                httpServerUpgradeHandler$UpgradeEvent.release();
            }
            return;
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)object;
            this.encoder().writeData(channelHandlerContext, http2DataFrame.stream().id(), http2DataFrame.content(), http2DataFrame.padding(), http2DataFrame.isEndStream(), channelPromise);
        } else if (object instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(channelHandlerContext, (Http2HeadersFrame)object, channelPromise);
        } else if (object instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
            Http2FrameStream http2FrameStream = http2WindowUpdateFrame.stream();
            try {
                if (http2FrameStream == null) {
                    this.increaseInitialConnectionWindow(http2WindowUpdateFrame.windowSizeIncrement());
                } else {
                    this.consumeBytes(http2FrameStream.id(), http2WindowUpdateFrame.windowSizeIncrement());
                }
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else if (object instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)object;
            int n4 = http2ResetFrame.stream().id();
            if (this.connection().streamMayHaveExisted(n4)) {
                this.encoder().writeRstStream(channelHandlerContext, http2ResetFrame.stream().id(), http2ResetFrame.errorCode(), channelPromise);
            } else {
                ReferenceCountUtil.release(http2ResetFrame);
                channelPromise.setFailure(Http2Exception.streamError(http2ResetFrame.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
            }
        } else if (object instanceof Http2PingFrame) {
            Http2PingFrame http2PingFrame = (Http2PingFrame)object;
            this.encoder().writePing(channelHandlerContext, http2PingFrame.ack(), http2PingFrame.content(), channelPromise);
        } else if (object instanceof Http2SettingsFrame) {
            this.encoder().writeSettings(channelHandlerContext, ((Http2SettingsFrame)object).settings(), channelPromise);
        } else if (object instanceof Http2SettingsAckFrame) {
            this.encoder().writeSettingsAck(channelHandlerContext, channelPromise);
        } else if (object instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object, channelPromise);
        } else if (object instanceof Http2UnknownFrame) {
            Http2UnknownFrame http2UnknownFrame = (Http2UnknownFrame)object;
            this.encoder().writeFrame(channelHandlerContext, http2UnknownFrame.frameType(), http2UnknownFrame.stream().id(), http2UnknownFrame.flags(), http2UnknownFrame.content(), channelPromise);
        } else if (!(object instanceof Http2Frame)) {
            channelHandlerContext.write(object, channelPromise);
        } else {
            ReferenceCountUtil.release(object);
            throw new UnsupportedMessageTypeException(object, new Class[0]);
        }
    }

    private void increaseInitialConnectionWindow(int n4) {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), n4);
    }

    final boolean consumeBytes(int n4, int n7) {
        Boolean bl3;
        Http2Stream http2Stream = this.connection().stream(n4);
        if (http2Stream != null && n4 == 1 && Boolean.TRUE.equals(bl3 = (Boolean)http2Stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(http2Stream, n7);
    }

    private void writeGoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() > -1) {
            http2GoAwayFrame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n4 = this.connection().remote().lastStreamCreated();
        long l2 = (long)n4 + (long)http2GoAwayFrame.extraStreamIds() * 2L;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        this.goAway(channelHandlerContext, (int)l2, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content(), channelPromise);
    }

    private void writeHeadersFrame(ChannelHandlerContext channelHandlerContext, Http2HeadersFrame http2HeadersFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2HeadersFrame.stream().id())) {
            this.encoder().writeHeaders(channelHandlerContext, http2HeadersFrame.stream().id(), http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
        } else {
            Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = (Http2FrameCodec$DefaultHttp2FrameStream)http2HeadersFrame.stream();
            Http2Connection http2Connection = this.connection();
            int n4 = http2Connection.local().incrementAndGetNextStreamId();
            if (n4 < 0) {
                channelPromise.setFailure(new Http2NoMoreStreamIdsException());
                this.onHttp2Frame(channelHandlerContext, new DefaultHttp2GoAwayFrame(http2Connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii(channelHandlerContext.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation")));
                return;
            }
            Http2FrameCodec$DefaultHttp2FrameStream.access$402(http2FrameCodec$DefaultHttp2FrameStream, n4);
            Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream2 = this.frameStreamToInitializeMap.put(n4, http2FrameCodec$DefaultHttp2FrameStream);
            assert (http2FrameCodec$DefaultHttp2FrameStream2 == null);
            this.encoder().writeHeaders(channelHandlerContext, n4, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
            if (!channelPromise.isDone()) {
                ++this.numBufferedStreams;
                channelPromise.addListener(this.bufferedStreamsListener);
            }
        }
    }

    private void onStreamActive0(Http2Stream http2Stream) {
        if (http2Stream.id() != 1 && this.connection().local().isValidStreamId(http2Stream.id())) {
            return;
        }
        Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = this.newStream().setStreamAndProperty(this.streamKey, http2Stream);
        this.onHttp2StreamStateChanged(this.ctx, http2FrameCodec$DefaultHttp2FrameStream);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl3, Throwable throwable, Http2Exception http2Exception) {
        if (!bl3) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
        super.onConnectionError(channelHandlerContext, bl3, throwable, http2Exception);
    }

    @Override
    protected final void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl3, Throwable throwable, Http2Exception$StreamException http2Exception$StreamException) {
        int n4 = http2Exception$StreamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n4);
        if (http2Stream == null) {
            this.onHttp2UnknownStreamError(channelHandlerContext, throwable, http2Exception$StreamException);
            super.onStreamError(channelHandlerContext, bl3, throwable, http2Exception$StreamException);
            return;
        }
        Http2FrameStream http2FrameStream = (Http2FrameStream)http2Stream.getProperty(this.streamKey);
        if (http2FrameStream == null) {
            LOG.warn("Stream exception thrown without stream object attached.", throwable);
            super.onStreamError(channelHandlerContext, bl3, throwable, http2Exception$StreamException);
            return;
        }
        if (!bl3) {
            this.onHttp2FrameStreamException(channelHandlerContext, new Http2FrameStreamException(http2FrameStream, http2Exception$StreamException.error(), throwable));
        }
    }

    private void onHttp2UnknownStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception$StreamException http2Exception$StreamException) {
        LOG.warn("Stream exception thrown for unknown stream {}.", (Object)http2Exception$StreamException.streamId(), (Object)throwable);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    private void onUpgradeEvent(ChannelHandlerContext channelHandlerContext, HttpServerUpgradeHandler$UpgradeEvent httpServerUpgradeHandler$UpgradeEvent) {
        channelHandlerContext.fireUserEventTriggered(httpServerUpgradeHandler$UpgradeEvent);
    }

    private void onHttp2StreamWritabilityChanged(ChannelHandlerContext channelHandlerContext, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream, boolean bl3) {
        channelHandlerContext.fireUserEventTriggered(http2FrameCodec$DefaultHttp2FrameStream.writabilityChanged);
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream) {
        channelHandlerContext.fireUserEventTriggered(http2FrameCodec$DefaultHttp2FrameStream.stateChanged);
    }

    void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        channelHandlerContext.fireChannelRead(http2Frame);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        channelHandlerContext.fireExceptionCaught(http2FrameStreamException);
    }

    static /* synthetic */ int access$010(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.numBufferedStreams--;
    }

    static /* synthetic */ IntObjectMap access$500(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.frameStreamToInitializeMap;
    }

    static /* synthetic */ void access$600(Http2FrameCodec http2FrameCodec, Http2Stream http2Stream) {
        http2FrameCodec.onStreamActive0(http2Stream);
    }

    static /* synthetic */ void access$700(Http2FrameCodec http2FrameCodec, ChannelHandlerContext channelHandlerContext, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream, boolean bl3) {
        http2FrameCodec.onHttp2StreamWritabilityChanged(channelHandlerContext, http2FrameCodec$DefaultHttp2FrameStream, bl3);
    }
}

