/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

public final class Http2Flags {
    public static final short END_STREAM = 1;
    public static final short END_HEADERS = 4;
    public static final short ACK = 1;
    public static final short PADDED = 8;
    public static final short PRIORITY = 32;
    private short value;

    public Http2Flags() {
    }

    public Http2Flags(short s11) {
        this.value = s11;
    }

    public short value() {
        return this.value;
    }

    public boolean endOfStream() {
        return this.isFlagSet((short)1);
    }

    public boolean endOfHeaders() {
        return this.isFlagSet((short)4);
    }

    public boolean priorityPresent() {
        return this.isFlagSet((short)32);
    }

    public boolean ack() {
        return this.isFlagSet((short)1);
    }

    public boolean paddingPresent() {
        return this.isFlagSet((short)8);
    }

    public int getNumPriorityBytes() {
        return this.priorityPresent() ? 5 : 0;
    }

    public int getPaddingPresenceFieldLength() {
        return this.paddingPresent() ? 1 : 0;
    }

    public Http2Flags endOfStream(boolean bl3) {
        return this.setFlag(bl3, (short)1);
    }

    public Http2Flags endOfHeaders(boolean bl3) {
        return this.setFlag(bl3, (short)4);
    }

    public Http2Flags priorityPresent(boolean bl3) {
        return this.setFlag(bl3, (short)32);
    }

    public Http2Flags paddingPresent(boolean bl3) {
        return this.setFlag(bl3, (short)8);
    }

    public Http2Flags ack(boolean bl3) {
        return this.setFlag(bl3, (short)1);
    }

    public Http2Flags setFlag(boolean bl3, short s11) {
        this.value = bl3 ? (short)(this.value | s11) : (short)(this.value & ~s11);
        return this;
    }

    public boolean isFlagSet(short s11) {
        return (this.value & s11) != 0;
    }

    public int hashCode() {
        int n4 = 31;
        int n7 = 1;
        n7 = 31 * n7 + this.value;
        return n7;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.value == ((Http2Flags)object).value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("value = ").append(this.value).append(" (");
        if (this.ack()) {
            stringBuilder.append("ACK,");
        }
        if (this.endOfHeaders()) {
            stringBuilder.append("END_OF_HEADERS,");
        }
        if (this.endOfStream()) {
            stringBuilder.append("END_OF_STREAM,");
        }
        if (this.priorityPresent()) {
            stringBuilder.append("PRIORITY_PRESENT,");
        }
        if (this.paddingPresent()) {
            stringBuilder.append("PADDING_PRESENT,");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

