/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$3;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$4;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$5;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$BaseDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$ClosingChannelFutureListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler$PrefaceDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$CompositeStreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$HeaderListSizeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$ShutdownHint;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$StreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LifecycleManager;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream$State;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Http2ConnectionHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
Http2LifecycleManager {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ConnectionHandler.class);
    private static final Http2Headers HEADERS_TOO_LARGE_HEADERS = ReadOnlyHttp2Headers.serverHeaders(false, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.codeAsText(), new AsciiString[0]);
    private static final ByteBuf HTTP_1_X_BUF = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{72, 84, 84, 80, 47, 49, 46})).asReadOnly();
    private final Http2ConnectionDecoder decoder;
    private final Http2ConnectionEncoder encoder;
    private final Http2Settings initialSettings;
    private final boolean decoupleCloseAndGoAway;
    private ChannelFutureListener closeListener;
    private Http2ConnectionHandler$BaseDecoder byteDecoder;
    private long gracefulShutdownTimeoutMillis;

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, false);
    }

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl3) {
        this.initialSettings = ObjectUtil.checkNotNull(http2Settings, "initialSettings");
        this.decoder = ObjectUtil.checkNotNull(http2ConnectionDecoder, "decoder");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.decoupleCloseAndGoAway = bl3;
        if (http2ConnectionEncoder.connection() != http2ConnectionDecoder.connection()) {
            throw new IllegalArgumentException("Encoder and Decoder do not share the same connection object");
        }
    }

    public long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    public void gracefulShutdownTimeoutMillis(long l2) {
        if (l2 < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + l2 + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = l2;
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    private boolean prefaceSent() {
        return this.byteDecoder != null && this.byteDecoder.prefaceSent();
    }

    public void onHttpClientUpgrade() {
        if (this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client-side HTTP upgrade requested for a server", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.connection().local().createStream(1, true);
    }

    public void onHttpServerUpgrade(Http2Settings http2Settings) {
        if (!this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server-side HTTP upgrade requested for a client", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.encoder.remoteSettings(http2Settings);
        this.connection().remote().createStream(1, true);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        try {
            this.encoder.flowController().writePendingBytes();
            channelHandlerContext.flush();
        }
        catch (Http2Exception http2Exception) {
            this.onError(channelHandlerContext, true, http2Exception);
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Error flushing", new Object[0]));
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.encoder.lifecycleManager(this);
        this.decoder.lifecycleManager(this);
        this.encoder.flowController().channelHandlerContext(channelHandlerContext);
        this.decoder.flowController().channelHandlerContext(channelHandlerContext);
        this.byteDecoder = new Http2ConnectionHandler$PrefaceDecoder(this, channelHandlerContext);
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        if (this.byteDecoder != null) {
            this.byteDecoder.handlerRemoved(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (this.byteDecoder == null) {
            this.byteDecoder = new Http2ConnectionHandler$PrefaceDecoder(this, channelHandlerContext);
        }
        this.byteDecoder.channelActive(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        super.channelInactive(channelHandlerContext);
        if (this.byteDecoder != null) {
            this.byteDecoder.channelInactive(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        try {
            if (channelHandlerContext.channel().isWritable()) {
                this.flush(channelHandlerContext);
            }
            this.encoder.flowController().channelWritabilityChanged();
        }
        finally {
            super.channelWritabilityChanged(channelHandlerContext);
        }
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.decoupleCloseAndGoAway) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        channelPromise = channelPromise.unvoid();
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.connection().goAwaySent() ? channelHandlerContext.write(Unpooled.EMPTY_BUFFER) : this.goAway(channelHandlerContext, null, channelHandlerContext.newPromise());
        channelHandlerContext.flush();
        this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
    }

    private ChannelFutureListener newClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        long l2 = this.gracefulShutdownTimeoutMillis;
        return l2 < 0L ? new Http2ConnectionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise) : new Http2ConnectionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise, l2, TimeUnit.MILLISECONDS);
    }

    private void doGracefulShutdown(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFutureListener channelFutureListener = this.newClosingChannelFutureListener(channelHandlerContext, channelPromise);
        if (this.isGracefulShutdownComplete()) {
            channelFuture.addListener(channelFutureListener);
        } else if (this.closeListener == null) {
            this.closeListener = channelFutureListener;
        } else if (channelPromise != null) {
            ChannelFutureListener channelFutureListener2 = this.closeListener;
            this.closeListener = new Http2ConnectionHandler$1(this, channelFutureListener2, channelFutureListener);
        }
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        try {
            this.channelReadComplete0(channelHandlerContext);
        }
        finally {
            this.flush(channelHandlerContext);
        }
    }

    final void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (Http2CodecUtil.getEmbeddedHttp2Exception(throwable) != null) {
            this.onError(channelHandlerContext, false, throwable);
        } else {
            super.exceptionCaught(channelHandlerContext, throwable);
        }
    }

    @Override
    public void closeStreamLocal(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case HALF_CLOSED_LOCAL: 
            case OPEN: {
                http2Stream.closeLocalSide();
                break;
            }
            default: {
                this.closeStream(http2Stream, channelFuture);
            }
        }
    }

    @Override
    public void closeStreamRemote(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                http2Stream.closeRemoteSide();
                break;
            }
            default: {
                this.closeStream(http2Stream, channelFuture);
            }
        }
    }

    @Override
    public void closeStream(Http2Stream http2Stream, ChannelFuture channelFuture) {
        http2Stream.close();
        if (channelFuture.isDone()) {
            this.checkCloseConnection(channelFuture);
        } else {
            channelFuture.addListener(new Http2ConnectionHandler$2(this));
        }
    }

    @Override
    public void onError(ChannelHandlerContext channelHandlerContext, boolean bl3, Throwable throwable) {
        Http2Exception http2Exception = Http2CodecUtil.getEmbeddedHttp2Exception(throwable);
        if (Http2Exception.isStreamError(http2Exception)) {
            this.onStreamError(channelHandlerContext, bl3, throwable, (Http2Exception$StreamException)http2Exception);
        } else if (http2Exception instanceof Http2Exception$CompositeStreamException) {
            Http2Exception$CompositeStreamException http2Exception$CompositeStreamException = (Http2Exception$CompositeStreamException)http2Exception;
            for (Http2Exception$StreamException http2Exception$StreamException : http2Exception$CompositeStreamException) {
                this.onStreamError(channelHandlerContext, bl3, throwable, http2Exception$StreamException);
            }
        } else {
            this.onConnectionError(channelHandlerContext, bl3, throwable, http2Exception);
        }
        channelHandlerContext.flush();
    }

    protected boolean isGracefulShutdownComplete() {
        return this.connection().numActiveStreams() == 0;
    }

    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl3, Throwable throwable, Http2Exception http2Exception) {
        if (http2Exception == null) {
            http2Exception = new Http2Exception(Http2Error.INTERNAL_ERROR, throwable.getMessage(), throwable);
        }
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        ChannelFuture channelFuture = this.goAway(channelHandlerContext, http2Exception, channelHandlerContext.newPromise());
        if (http2Exception.shutdownHint() == Http2Exception$ShutdownHint.GRACEFUL_SHUTDOWN) {
            this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
        } else {
            channelFuture.addListener(this.newClosingChannelFutureListener(channelHandlerContext, channelPromise));
        }
    }

    protected void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl3, Throwable throwable, Http2Exception$StreamException http2Exception$StreamException) {
        int n4 = http2Exception$StreamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n4);
        if (http2Exception$StreamException instanceof Http2Exception$HeaderListSizeException && ((Http2Exception$HeaderListSizeException)http2Exception$StreamException).duringDecode() && this.connection().isServer()) {
            if (http2Stream == null) {
                try {
                    http2Stream = this.encoder.connection().remote().createStream(n4, true);
                }
                catch (Http2Exception http2Exception) {
                    this.resetUnknownStream(channelHandlerContext, n4, http2Exception$StreamException.error().code(), channelHandlerContext.newPromise());
                    return;
                }
            }
            if (http2Stream != null && !http2Stream.isHeadersSent()) {
                try {
                    this.handleServerHeaderDecodeSizeError(channelHandlerContext, http2Stream);
                }
                catch (Throwable throwable2) {
                    this.onError(channelHandlerContext, bl3, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable2, "Error DecodeSizeError", new Object[0]));
                }
            }
        }
        if (http2Stream == null) {
            if (!bl3 || this.connection().local().mayHaveCreatedStream(n4)) {
                this.resetUnknownStream(channelHandlerContext, n4, http2Exception$StreamException.error().code(), channelHandlerContext.newPromise());
            }
        } else {
            this.resetStream(channelHandlerContext, http2Stream, http2Exception$StreamException.error().code(), channelHandlerContext.newPromise());
        }
    }

    protected void handleServerHeaderDecodeSizeError(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream) {
        this.encoder().writeHeaders(channelHandlerContext, http2Stream.id(), HEADERS_TOO_LARGE_HEADERS, 0, true, channelHandlerContext.newPromise());
    }

    public Http2FrameWriter frameWriter() {
        return this.encoder().frameWriter();
    }

    private ChannelFuture resetUnknownStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.frameWriter().writeRstStream(channelHandlerContext, n4, l2, channelPromise);
        if (channelFuture.isDone()) {
            this.closeConnectionOnError(channelHandlerContext, channelFuture);
        } else {
            channelFuture.addListener(new Http2ConnectionHandler$3(this, channelHandlerContext));
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture resetStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        Http2Stream http2Stream = this.connection().stream(n4);
        if (http2Stream == null) {
            return this.resetUnknownStream(channelHandlerContext, n4, l2, channelPromise.unvoid());
        }
        return this.resetStream(channelHandlerContext, http2Stream, l2, channelPromise);
    }

    private ChannelFuture resetStream(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, long l2, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        if (http2Stream.isResetSent()) {
            return channelPromise.setSuccess();
        }
        ChannelFuture channelFuture = http2Stream.state() == Http2Stream$State.IDLE || this.connection().local().created(http2Stream) && !http2Stream.isHeadersSent() && !http2Stream.isPushPromiseSent() ? channelPromise.setSuccess() : this.frameWriter().writeRstStream(channelHandlerContext, http2Stream.id(), l2, channelPromise);
        http2Stream.resetSent();
        if (channelFuture.isDone()) {
            this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
        } else {
            channelFuture.addListener(new Http2ConnectionHandler$4(this, channelHandlerContext, http2Stream));
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture goAway(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        channelPromise = channelPromise.unvoid();
        Http2Connection http2Connection = this.connection();
        try {
            if (!http2Connection.goAwaySent(n4, l2, byteBuf)) {
                byteBuf.release();
                channelPromise.trySuccess();
                return channelPromise;
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
        byteBuf.retain();
        ChannelFuture channelFuture = this.frameWriter().writeGoAway(channelHandlerContext, n4, l2, byteBuf, channelPromise);
        if (channelFuture.isDone()) {
            Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n4, l2, byteBuf, channelFuture);
        } else {
            channelFuture.addListener(new Http2ConnectionHandler$5(this, channelHandlerContext, n4, l2, byteBuf));
        }
        return channelFuture;
    }

    private void checkCloseConnection(ChannelFuture channelFuture) {
        if (this.closeListener != null && this.isGracefulShutdownComplete()) {
            ChannelFutureListener channelFutureListener = this.closeListener;
            this.closeListener = null;
            try {
                channelFutureListener.operationComplete(channelFuture);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Close listener threw an unexpected exception", exception);
            }
        }
    }

    private ChannelFuture goAway(ChannelHandlerContext channelHandlerContext, Http2Exception http2Exception, ChannelPromise channelPromise) {
        long l2 = http2Exception != null ? http2Exception.error().code() : Http2Error.NO_ERROR.code();
        int n4 = this.connection().remote().lastStreamCreated();
        return this.goAway(channelHandlerContext, n4, l2, Http2CodecUtil.toByteBuf(channelHandlerContext, http2Exception), channelPromise);
    }

    private void processRstStreamWriteResult(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, ChannelFuture channelFuture) {
        if (channelFuture.isSuccess()) {
            this.closeStream(http2Stream, channelFuture);
        } else {
            this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
        }
    }

    private void closeConnectionOnError(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.onConnectionError(channelHandlerContext, true, channelFuture.cause(), null);
        }
    }

    private static ByteBuf clientPrefaceString(Http2Connection http2Connection) {
        return http2Connection.isServer() ? Http2CodecUtil.connectionPrefaceBuf() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processGoAwayWriteResult(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelFuture channelFuture) {
        try {
            if (channelFuture.isSuccess()) {
                if (l2 != Http2Error.NO_ERROR.code()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Sent GOAWAY: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n4, l2, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                    }
                    channelHandlerContext.close();
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Sending GOAWAY failed: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n4, l2, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                }
                channelHandlerContext.close();
            }
        }
        finally {
            byteBuf.release();
        }
    }

    static /* synthetic */ Http2ConnectionEncoder access$100(Http2ConnectionHandler http2ConnectionHandler) {
        return http2ConnectionHandler.encoder;
    }

    static /* synthetic */ ByteBuf access$200(Http2Connection http2Connection) {
        return Http2ConnectionHandler.clientPrefaceString(http2Connection);
    }

    static /* synthetic */ Http2ConnectionHandler$BaseDecoder access$302(Http2ConnectionHandler http2ConnectionHandler, Http2ConnectionHandler$BaseDecoder http2ConnectionHandler$BaseDecoder) {
        http2ConnectionHandler.byteDecoder = http2ConnectionHandler$BaseDecoder;
        return http2ConnectionHandler.byteDecoder;
    }

    static /* synthetic */ Http2ConnectionHandler$BaseDecoder access$300(Http2ConnectionHandler http2ConnectionHandler) {
        return http2ConnectionHandler.byteDecoder;
    }

    static /* synthetic */ ByteBuf access$500() {
        return HTTP_1_X_BUF;
    }

    static /* synthetic */ Http2Settings access$600(Http2ConnectionHandler http2ConnectionHandler) {
        return http2ConnectionHandler.initialSettings;
    }

    static /* synthetic */ Http2ConnectionDecoder access$700(Http2ConnectionHandler http2ConnectionHandler) {
        return http2ConnectionHandler.decoder;
    }

    static /* synthetic */ void access$800(Http2ConnectionHandler http2ConnectionHandler, ChannelFuture channelFuture) {
        http2ConnectionHandler.checkCloseConnection(channelFuture);
    }

    static /* synthetic */ void access$900(Http2ConnectionHandler http2ConnectionHandler, ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture) {
        http2ConnectionHandler.closeConnectionOnError(channelHandlerContext, channelFuture);
    }

    static /* synthetic */ void access$1000(Http2ConnectionHandler http2ConnectionHandler, ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, ChannelFuture channelFuture) {
        http2ConnectionHandler.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
    }

    static /* synthetic */ void access$1100(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelFuture channelFuture) {
        Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n4, l2, byteBuf, channelFuture);
    }
}

