/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackEncoder$HeaderEntry;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHeaderField;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackStaticTable;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackUtil$IndexType;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Map;

final class HpackEncoder {
    static final int HUFF_CODE_THRESHOLD = 512;
    private final HpackEncoder$HeaderEntry[] headerFields;
    private final HpackEncoder$HeaderEntry head = new HpackEncoder$HeaderEntry(-1, AsciiString.EMPTY_STRING, AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
    private final HpackHuffmanEncoder hpackHuffmanEncoder = new HpackHuffmanEncoder();
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    HpackEncoder(boolean bl3) {
        this(bl3, 16, 512);
    }

    HpackEncoder(boolean bl3, int n4, int n7) {
        this.ignoreMaxHeaderListSize = bl3;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.headerFields = new HpackEncoder$HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n4, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
        this.huffCodeThreshold = n7;
    }

    public void encodeHeaders(int n4, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
        } else {
            this.encodeHeadersEnforceMaxHeaderListSize(n4, byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
        }
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int n4, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        long l2 = 0L;
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            CharSequence charSequence;
            CharSequence charSequence2 = entry.getKey();
            if ((l2 += HpackHeaderField.sizeOf(charSequence2, charSequence = entry.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(n4, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            CharSequence charSequence = entry.getKey();
            CharSequence charSequence2 = entry.getValue();
            this.encodeHeader(byteBuf, charSequence, charSequence2, http2HeadersEncoder$SensitivityDetector.isSensitive(charSequence, charSequence2), HpackHeaderField.sizeOf(charSequence, charSequence2));
        }
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean bl3, long l2) {
        if (bl3) {
            int n4 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NEVER, n4);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int n7 = HpackStaticTable.getIndex(charSequence, charSequence2);
            if (n7 == -1) {
                int n8 = HpackStaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NONE, n8);
            } else {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n7);
            }
            return;
        }
        if (l2 > this.maxHeaderTableSize) {
            int n10 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NONE, n10);
            return;
        }
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.getEntry(charSequence, charSequence2);
        if (hpackEncoder$HeaderEntry != null) {
            int n11 = this.getIndex(hpackEncoder$HeaderEntry.index) + HpackStaticTable.length;
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n11);
        } else {
            int n12 = HpackStaticTable.getIndex(charSequence, charSequence2);
            if (n12 != -1) {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n12);
            } else {
                this.ensureCapacity(l2);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.INCREMENTAL, this.getNameIndex(charSequence));
                this.add(charSequence, charSequence2, l2);
            }
        }
    }

    public void setMaxHeaderTableSize(ByteBuf byteBuf, long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        if (this.maxHeaderTableSize == l2) {
            return;
        }
        this.maxHeaderTableSize = l2;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(byteBuf, 32, 5, l2);
    }

    public long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderListSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n4, int n7, int n8) {
        HpackEncoder.encodeInteger(byteBuf, n4, n7, (long)n8);
    }

    private static void encodeInteger(ByteBuf byteBuf, int n4, int n7, long l2) {
        assert (n7 >= 0 && n7 <= 8) : "N: " + n7;
        int n8 = 255 >>> 8 - n7;
        if (l2 < (long)n8) {
            byteBuf.writeByte((int)((long)n4 | l2));
        } else {
            byteBuf.writeByte(n4 | n8);
            long l10 = l2 - (long)n8;
            while ((l10 & 0xFFFFFFFFFFFFFF80L) != 0L) {
                byteBuf.writeByte((int)(l10 & 0x7FL | 0x80L));
                l10 >>>= 7;
            }
            byteBuf.writeByte((int)l10);
        }
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n4;
        if (charSequence.length() >= this.huffCodeThreshold && (n4 = this.hpackHuffmanEncoder.getEncodedLength(charSequence)) < charSequence.length()) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n4);
            this.hpackHuffmanEncoder.encode(byteBuf, charSequence);
        } else {
            HpackEncoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
            if (charSequence instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)charSequence;
                byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil$IndexType hpackUtil$IndexType, int n4) {
        boolean bl3 = n4 != -1;
        switch (hpackUtil$IndexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(byteBuf, 64, 6, bl3 ? n4 : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(byteBuf, 0, 4, bl3 ? n4 : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(byteBuf, 16, 4, bl3 ? n4 : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!bl3) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence charSequence) {
        int n4 = HpackStaticTable.getIndex(charSequence);
        if (n4 == -1 && (n4 = this.getIndex(charSequence)) >= 0) {
            n4 += HpackStaticTable.length;
        }
        return n4;
    }

    private void ensureCapacity(long l2) {
        int n4;
        while (this.maxHeaderTableSize - this.size < l2 && (n4 = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0L ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    long size() {
        return this.size;
    }

    HpackHeaderField getHeaderField(int n4) {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.head;
        while (n4-- >= 0) {
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.before;
        }
        return hpackEncoder$HeaderEntry;
    }

    private HpackEncoder$HeaderEntry getEntry(CharSequence charSequence, CharSequence charSequence2) {
        if (this.length() == 0 || charSequence == null || charSequence2 == null) {
            return null;
        }
        int n4 = AsciiString.hashCode(charSequence);
        int n7 = this.index(n4);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.headerFields[n7];
        while (hpackEncoder$HeaderEntry != null) {
            if (hpackEncoder$HeaderEntry.hash == n4 && (HpackUtil.equalsConstantTime(charSequence, hpackEncoder$HeaderEntry.name) & HpackUtil.equalsConstantTime(charSequence2, hpackEncoder$HeaderEntry.value)) != 0) {
                return hpackEncoder$HeaderEntry;
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.next;
        }
        return null;
    }

    private int getIndex(CharSequence charSequence) {
        if (this.length() == 0 || charSequence == null) {
            return -1;
        }
        int n4 = AsciiString.hashCode(charSequence);
        int n7 = this.index(n4);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.headerFields[n7];
        while (hpackEncoder$HeaderEntry != null) {
            if (hpackEncoder$HeaderEntry.hash == n4 && HpackUtil.equalsConstantTime(charSequence, hpackEncoder$HeaderEntry.name) != 0) {
                return this.getIndex(hpackEncoder$HeaderEntry.index);
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.next;
        }
        return -1;
    }

    private int getIndex(int n4) {
        return n4 == -1 ? -1 : n4 - this.head.before.index + 1;
    }

    private void add(CharSequence charSequence, CharSequence charSequence2, long l2) {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry;
        if (l2 > this.maxHeaderTableSize) {
            this.clear();
            return;
        }
        while (this.maxHeaderTableSize - this.size < l2) {
            this.remove();
        }
        int n4 = AsciiString.hashCode(charSequence);
        int n7 = this.index(n4);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry2 = this.headerFields[n7];
        this.headerFields[n7] = hpackEncoder$HeaderEntry = new HpackEncoder$HeaderEntry(n4, charSequence, charSequence2, this.head.before.index - 1, hpackEncoder$HeaderEntry2);
        HpackEncoder$HeaderEntry.access$000(hpackEncoder$HeaderEntry, this.head);
        this.size += l2;
    }

    private HpackHeaderField remove() {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry;
        if (this.size == 0L) {
            return null;
        }
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry2 = this.head.after;
        int n4 = hpackEncoder$HeaderEntry2.hash;
        int n7 = this.index(n4);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry3 = hpackEncoder$HeaderEntry = this.headerFields[n7];
        while (hpackEncoder$HeaderEntry3 != null) {
            HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry4 = hpackEncoder$HeaderEntry3.next;
            if (hpackEncoder$HeaderEntry3 == hpackEncoder$HeaderEntry2) {
                if (hpackEncoder$HeaderEntry == hpackEncoder$HeaderEntry2) {
                    this.headerFields[n7] = hpackEncoder$HeaderEntry4;
                } else {
                    hpackEncoder$HeaderEntry.next = hpackEncoder$HeaderEntry4;
                }
                HpackEncoder$HeaderEntry.access$100(hpackEncoder$HeaderEntry2);
                this.size -= (long)hpackEncoder$HeaderEntry2.size();
                return hpackEncoder$HeaderEntry2;
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry3;
            hpackEncoder$HeaderEntry3 = hpackEncoder$HeaderEntry4;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0L;
    }

    private int index(int n4) {
        return n4 & this.hashMask;
    }
}

