/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHeaderField;

final class HpackDynamicTable {
    HpackHeaderField[] hpackHeaderFields;
    int head;
    int tail;
    private long size;
    private long capacity = -1L;

    HpackDynamicTable(long l2) {
        this.setCapacity(l2);
    }

    public int length() {
        int n4 = this.head < this.tail ? this.hpackHeaderFields.length - this.tail + this.head : this.head - this.tail;
        return n4;
    }

    public long size() {
        return this.size;
    }

    public long capacity() {
        return this.capacity;
    }

    public HpackHeaderField getEntry(int n4) {
        if (n4 <= 0 || n4 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = this.head - n4;
        if (n7 < 0) {
            return this.hpackHeaderFields[n7 + this.hpackHeaderFields.length];
        }
        return this.hpackHeaderFields[n7];
    }

    public void add(HpackHeaderField hpackHeaderField) {
        int n4 = hpackHeaderField.size();
        if ((long)n4 > this.capacity) {
            this.clear();
            return;
        }
        while (this.capacity - this.size < (long)n4) {
            this.remove();
        }
        this.hpackHeaderFields[this.head++] = hpackHeaderField;
        this.size += (long)hpackHeaderField.size();
        if (this.head == this.hpackHeaderFields.length) {
            this.head = 0;
        }
    }

    public HpackHeaderField remove() {
        HpackHeaderField hpackHeaderField = this.hpackHeaderFields[this.tail];
        if (hpackHeaderField == null) {
            return null;
        }
        this.size -= (long)hpackHeaderField.size();
        this.hpackHeaderFields[this.tail++] = null;
        if (this.tail == this.hpackHeaderFields.length) {
            this.tail = 0;
        }
        return hpackHeaderField;
    }

    public void clear() {
        while (this.tail != this.head) {
            this.hpackHeaderFields[this.tail++] = null;
            if (this.tail != this.hpackHeaderFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0L;
    }

    public void setCapacity(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("capacity is invalid: " + l2);
        }
        if (this.capacity == l2) {
            return;
        }
        this.capacity = l2;
        if (l2 == 0L) {
            this.clear();
        } else {
            while (this.size > l2) {
                this.remove();
            }
        }
        int n4 = (int)(l2 / 32L);
        if (l2 % 32L != 0L) {
            ++n4;
        }
        if (this.hpackHeaderFields != null && this.hpackHeaderFields.length == n4) {
            return;
        }
        HpackHeaderField[] hpackHeaderFieldArray = new HpackHeaderField[n4];
        int n7 = this.length();
        int n8 = this.tail;
        for (int i3 = 0; i3 < n7; ++i3) {
            HpackHeaderField hpackHeaderField;
            hpackHeaderFieldArray[i3] = hpackHeaderField = this.hpackHeaderFields[n8++];
            if (n8 != this.hpackHeaderFields.length) continue;
            n8 = 0;
        }
        this.tail = 0;
        this.head = this.tail + n7;
        this.hpackHeaderFields = hpackHeaderFieldArray;
    }
}

