/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder$HeaderType;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder$Http2HeadersSink;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder$Sink;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDynamicTable;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHeaderField;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHuffmanDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackStaticTable;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackUtil$IndexType;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception$ShutdownHint;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ThrowableUtil;

final class HpackDecoder {
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - long overflow", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - int overflow", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decodeULE128ToInt(..)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decode(..)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "indexHeader(..)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "readName(..)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "setDynamicTableSize(..)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", Http2Exception$ShutdownHint.HARD_SHUTDOWN), HpackDecoder.class, "decode(..)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_MAX_DYNAMIC_TABLE_SIZE = 1;
    private static final byte READ_INDEXED_HEADER = 2;
    private static final byte READ_INDEXED_HEADER_NAME = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 4;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 5;
    private static final byte READ_LITERAL_HEADER_NAME = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 7;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 8;
    private static final byte READ_LITERAL_HEADER_VALUE = 9;
    private final HpackHuffmanDecoder huffmanDecoder = new HpackHuffmanDecoder();
    private final HpackDynamicTable hpackDynamicTable;
    private long maxHeaderListSize;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    HpackDecoder(long l2) {
        this(l2, 4096);
    }

    HpackDecoder(long l2, int n4) {
        this.maxHeaderListSize = ObjectUtil.checkPositive(l2, "maxHeaderListSize");
        this.maxDynamicTableSize = this.encoderMaxDynamicTableSize = (long)n4;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable = new HpackDynamicTable(n4);
    }

    public void decode(int n4, ByteBuf byteBuf, Http2Headers http2Headers, boolean bl3) {
        HpackDecoder$Http2HeadersSink hpackDecoder$Http2HeadersSink = new HpackDecoder$Http2HeadersSink(n4, http2Headers, this.maxHeaderListSize, bl3);
        this.decode(byteBuf, hpackDecoder$Http2HeadersSink);
        hpackDecoder$Http2HeadersSink.finish();
    }

    private void decode(ByteBuf byteBuf, HpackDecoder$Sink hpackDecoder$Sink) {
        int n4 = 0;
        int n7 = 0;
        int n8 = 0;
        int n10 = 0;
        boolean bl3 = false;
        CharSequence charSequence = null;
        HpackUtil$IndexType hpackUtil$IndexType = HpackUtil$IndexType.NONE;
        block28: while (byteBuf.isReadable()) {
            switch (n10) {
                case 0: {
                    HpackHeaderField hpackHeaderField;
                    byte by2 = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (by2 & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (by2 < 0) {
                        n4 = by2 & 0x7F;
                        switch (n4) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                n10 = 2;
                                continue block28;
                            }
                        }
                        hpackHeaderField = this.getIndexedHeader(n4);
                        hpackDecoder$Sink.appendToHeaderList(hpackHeaderField.name, hpackHeaderField.value);
                        continue block28;
                    }
                    if ((by2 & 0x40) == 64) {
                        hpackUtil$IndexType = HpackUtil$IndexType.INCREMENTAL;
                        n4 = by2 & 0x3F;
                        switch (n4) {
                            case 0: {
                                n10 = 4;
                                continue block28;
                            }
                            case 63: {
                                n10 = 3;
                                continue block28;
                            }
                        }
                        charSequence = this.readName(n4);
                        n7 = charSequence.length();
                        n10 = 7;
                        continue block28;
                    }
                    if ((by2 & 0x20) == 32) {
                        n4 = by2 & 0x1F;
                        if (n4 == 31) {
                            n10 = 1;
                            continue block28;
                        }
                        this.setDynamicTableSize(n4);
                        n10 = 0;
                        continue block28;
                    }
                    hpackUtil$IndexType = (by2 & 0x10) == 16 ? HpackUtil$IndexType.NEVER : HpackUtil$IndexType.NONE;
                    n4 = by2 & 0xF;
                    switch (n4) {
                        case 0: {
                            n10 = 4;
                            continue block28;
                        }
                        case 15: {
                            n10 = 3;
                            continue block28;
                        }
                    }
                    charSequence = this.readName(n4);
                    n7 = charSequence.length();
                    n10 = 7;
                    continue block28;
                }
                case 1: {
                    this.setDynamicTableSize(HpackDecoder.decodeULE128(byteBuf, (long)n4));
                    n10 = 0;
                    continue block28;
                }
                case 2: {
                    HpackHeaderField hpackHeaderField = this.getIndexedHeader(HpackDecoder.decodeULE128(byteBuf, n4));
                    hpackDecoder$Sink.appendToHeaderList(hpackHeaderField.name, hpackHeaderField.value);
                    n10 = 0;
                    continue block28;
                }
                case 3: {
                    charSequence = this.readName(HpackDecoder.decodeULE128(byteBuf, n4));
                    n7 = charSequence.length();
                    n10 = 7;
                    continue block28;
                }
                case 4: {
                    byte by2 = byteBuf.readByte();
                    bl3 = (by2 & 0x80) == 128;
                    n4 = by2 & 0x7F;
                    if (n4 == 127) {
                        n10 = 5;
                        continue block28;
                    }
                    n7 = n4;
                    n10 = 6;
                    continue block28;
                }
                case 5: {
                    n7 = HpackDecoder.decodeULE128(byteBuf, n4);
                    n10 = 6;
                    continue block28;
                }
                case 6: {
                    if (byteBuf.readableBytes() < n7) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    charSequence = this.readStringLiteral(byteBuf, n7, bl3);
                    n10 = 7;
                    continue block28;
                }
                case 7: {
                    byte by2 = byteBuf.readByte();
                    bl3 = (by2 & 0x80) == 128;
                    n4 = by2 & 0x7F;
                    switch (n4) {
                        case 127: {
                            n10 = 8;
                            continue block28;
                        }
                        case 0: {
                            this.insertHeader(hpackDecoder$Sink, charSequence, AsciiString.EMPTY_STRING, hpackUtil$IndexType);
                            n10 = 0;
                            continue block28;
                        }
                    }
                    n8 = n4;
                    n10 = 9;
                    continue block28;
                }
                case 8: {
                    n8 = HpackDecoder.decodeULE128(byteBuf, n4);
                    n10 = 9;
                    continue block28;
                }
                case 9: {
                    if (byteBuf.readableBytes() < n8) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    CharSequence charSequence2 = this.readStringLiteral(byteBuf, n8, bl3);
                    this.insertHeader(hpackDecoder$Sink, charSequence, charSequence2, hpackUtil$IndexType);
                    n10 = 0;
                    continue block28;
                }
            }
            throw new Error("should not reach here state: " + n10);
        }
        if (n10 != 0) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Incomplete header block fragment.", new Object[0]);
        }
    }

    public void setMaxHeaderTableSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxDynamicTableSize = l2;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.hpackDynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    @Deprecated
    public void setMaxHeaderListSize(long l2, long l10) {
        this.setMaxHeaderListSize(l2);
    }

    public void setMaxHeaderListSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public long getMaxHeaderTableSize() {
        return this.hpackDynamicTable.capacity();
    }

    int length() {
        return this.hpackDynamicTable.length();
    }

    long size() {
        return this.hpackDynamicTable.size();
    }

    HpackHeaderField getHeaderField(int n4) {
        return this.hpackDynamicTable.getEntry(n4 + 1);
    }

    private void setDynamicTableSize(long l2) {
        if (l2 > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = l2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable.setCapacity(l2);
    }

    private static HpackDecoder$HeaderType validate(int n4, CharSequence charSequence, HpackDecoder$HeaderType hpackDecoder$HeaderType) {
        if (Http2Headers$PseudoHeaderName.hasPseudoHeaderFormat(charSequence)) {
            HpackDecoder$HeaderType hpackDecoder$HeaderType2;
            if (hpackDecoder$HeaderType == HpackDecoder$HeaderType.REGULAR_HEADER) {
                throw Http2Exception.streamError(n4, Http2Error.PROTOCOL_ERROR, "Pseudo-header field '%s' found after regular header.", charSequence);
            }
            Http2Headers$PseudoHeaderName http2Headers$PseudoHeaderName = Http2Headers$PseudoHeaderName.getPseudoHeader(charSequence);
            if (http2Headers$PseudoHeaderName == null) {
                throw Http2Exception.streamError(n4, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 pseudo-header '%s' encountered.", charSequence);
            }
            HpackDecoder$HeaderType hpackDecoder$HeaderType3 = hpackDecoder$HeaderType2 = http2Headers$PseudoHeaderName.isRequestOnly() ? HpackDecoder$HeaderType.REQUEST_PSEUDO_HEADER : HpackDecoder$HeaderType.RESPONSE_PSEUDO_HEADER;
            if (hpackDecoder$HeaderType != null && hpackDecoder$HeaderType2 != hpackDecoder$HeaderType) {
                throw Http2Exception.streamError(n4, Http2Error.PROTOCOL_ERROR, "Mix of request and response pseudo-headers.", new Object[0]);
            }
            return hpackDecoder$HeaderType2;
        }
        return HpackDecoder$HeaderType.REGULAR_HEADER;
    }

    private CharSequence readName(int n4) {
        if (n4 <= HpackStaticTable.length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n4);
            return hpackHeaderField.name;
        }
        if (n4 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            HpackHeaderField hpackHeaderField = this.hpackDynamicTable.getEntry(n4 - HpackStaticTable.length);
            return hpackHeaderField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private HpackHeaderField getIndexedHeader(int n4) {
        if (n4 <= HpackStaticTable.length) {
            return HpackStaticTable.getEntry(n4);
        }
        if (n4 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            return this.hpackDynamicTable.getEntry(n4 - HpackStaticTable.length);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private void insertHeader(HpackDecoder$Sink hpackDecoder$Sink, CharSequence charSequence, CharSequence charSequence2, HpackUtil$IndexType hpackUtil$IndexType) {
        hpackDecoder$Sink.appendToHeaderList(charSequence, charSequence2);
        switch (hpackUtil$IndexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.hpackDynamicTable.add(new HpackHeaderField(charSequence, charSequence2));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
    }

    private CharSequence readStringLiteral(ByteBuf byteBuf, int n4, boolean bl3) {
        if (bl3) {
            return this.huffmanDecoder.decode(byteBuf, n4);
        }
        byte[] byArray = new byte[n4];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf byteBuf) {
        return new IllegalArgumentException("decode only works with an entire header block! " + byteBuf);
    }

    static int decodeULE128(ByteBuf byteBuf, int n4) {
        int n7 = byteBuf.readerIndex();
        long l2 = HpackDecoder.decodeULE128(byteBuf, (long)n4);
        if (l2 > Integer.MAX_VALUE) {
            byteBuf.readerIndex(n7);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)l2;
    }

    static long decodeULE128(ByteBuf byteBuf, long l2) {
        assert (l2 <= 127L && l2 >= 0L);
        boolean bl3 = l2 == 0L;
        int n4 = byteBuf.writerIndex();
        int n7 = byteBuf.readerIndex();
        int n8 = 0;
        while (n7 < n4) {
            byte by2 = byteBuf.getByte(n7);
            if (n8 == 56 && ((by2 & 0x80) != 0 || by2 == 127 && !bl3)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((by2 & 0x80) == 0) {
                byteBuf.readerIndex(n7 + 1);
                return l2 + (((long)by2 & 0x7FL) << n8);
            }
            l2 += ((long)by2 & 0x7FL) << n8;
            ++n7;
            n8 += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    static /* synthetic */ HpackDecoder$HeaderType access$000(int n4, CharSequence charSequence, HpackDecoder$HeaderType hpackDecoder$HeaderType) {
        return HpackDecoder.validate(n4, charSequence, hpackDecoder$HeaderType);
    }
}

