/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder$HeaderType;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackDecoder$Sink;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackHeaderField;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;

final class HpackDecoder$Http2HeadersSink
implements HpackDecoder$Sink {
    private final Http2Headers headers;
    private final long maxHeaderListSize;
    private final int streamId;
    private final boolean validate;
    private long headersLength;
    private boolean exceededMaxLength;
    private HpackDecoder$HeaderType previousType;
    private Http2Exception validationException;

    HpackDecoder$Http2HeadersSink(int n4, Http2Headers http2Headers, long l2, boolean bl3) {
        this.headers = http2Headers;
        this.maxHeaderListSize = l2;
        this.streamId = n4;
        this.validate = bl3;
    }

    @Override
    public void finish() {
        if (this.exceededMaxLength) {
            Http2CodecUtil.headerListSizeExceeded(this.streamId, this.maxHeaderListSize, true);
        } else if (this.validationException != null) {
            throw this.validationException;
        }
    }

    @Override
    public void appendToHeaderList(CharSequence charSequence, CharSequence charSequence2) {
        this.headersLength += HpackHeaderField.sizeOf(charSequence, charSequence2);
        this.exceededMaxLength |= this.headersLength > this.maxHeaderListSize;
        if (this.exceededMaxLength || this.validationException != null) {
            return;
        }
        if (this.validate) {
            try {
                this.previousType = HpackDecoder.access$000(this.streamId, charSequence, this.previousType);
            }
            catch (Http2Exception http2Exception) {
                this.validationException = http2Exception;
                return;
            }
        }
        this.headers.add(charSequence, charSequence2);
    }
}

