/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DelegatingDecompressorFrameListener$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DelegatingDecompressorFrameListener$ConsumedBytesConverter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DelegatingDecompressorFrameListener$Http2Decompressor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;

public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    private final Http2Connection$PropertyKey propertyKey;

    public DelegatingDecompressorFrameListener(Http2Connection http2Connection, Http2FrameListener http2FrameListener) {
        this(http2Connection, http2FrameListener, true);
    }

    public DelegatingDecompressorFrameListener(Http2Connection http2Connection, Http2FrameListener http2FrameListener, boolean bl3) {
        super(http2FrameListener);
        this.connection = http2Connection;
        this.strict = bl3;
        this.propertyKey = http2Connection.newKey();
        http2Connection.addListener(new DelegatingDecompressorFrameListener$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3) {
        int n8;
        Http2Stream http2Stream = this.connection.stream(n4);
        DelegatingDecompressorFrameListener$Http2Decompressor delegatingDecompressorFrameListener$Http2Decompressor = this.decompressor(http2Stream);
        if (delegatingDecompressorFrameListener$Http2Decompressor == null) {
            return this.listener.onDataRead(channelHandlerContext, n4, byteBuf, n7, bl3);
        }
        EmbeddedChannel embeddedChannel = delegatingDecompressorFrameListener$Http2Decompressor.decompressor();
        int n10 = byteBuf.readableBytes() + n7;
        delegatingDecompressorFrameListener$Http2Decompressor.incrementCompressedBytes(n10);
        embeddedChannel.writeInbound(byteBuf.retain());
        ByteBuf byteBuf2 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
        if (byteBuf2 == null && bl3 && embeddedChannel.finish()) {
            byteBuf2 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
        }
        if (byteBuf2 == null) {
            if (bl3) {
                this.listener.onDataRead(channelHandlerContext, n4, Unpooled.EMPTY_BUFFER, n7, true);
            }
            delegatingDecompressorFrameListener$Http2Decompressor.incrementDecompressedBytes(n10);
            return n10;
        }
        try {
            Http2LocalFlowController http2LocalFlowController = this.connection.local().flowController();
            delegatingDecompressorFrameListener$Http2Decompressor.incrementDecompressedBytes(n7);
            while (true) {
                ByteBuf byteBuf3;
                boolean bl4;
                boolean bl5 = bl4 = (byteBuf3 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel)) == null && bl3;
                if (bl4 && embeddedChannel.finish()) {
                    byteBuf3 = DelegatingDecompressorFrameListener.nextReadableBuf(embeddedChannel);
                    bl4 = byteBuf3 == null;
                }
                delegatingDecompressorFrameListener$Http2Decompressor.incrementDecompressedBytes(byteBuf2.readableBytes());
                http2LocalFlowController.consumeBytes(http2Stream, this.listener.onDataRead(channelHandlerContext, n4, byteBuf2, n7, bl4));
                if (byteBuf3 == null) break;
                n7 = 0;
                byteBuf2.release();
                byteBuf2 = byteBuf3;
            }
            n8 = 0;
        }
        catch (Throwable throwable) {
            try {
                byteBuf2.release();
                throw throwable;
            }
            catch (Http2Exception http2Exception) {
                throw http2Exception;
            }
            catch (Throwable throwable2) {
                throw Http2Exception.streamError(http2Stream.id(), Http2Error.INTERNAL_ERROR, throwable2, "Decompressor error detected while delegating data read on streamId %d", http2Stream.id());
            }
        }
        byteBuf2.release();
        return n8;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3) {
        this.initDecompressor(channelHandlerContext, n4, http2Headers, bl3);
        this.listener.onHeadersRead(channelHandlerContext, n4, http2Headers, n7, bl3);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4) {
        this.initDecompressor(channelHandlerContext, n4, http2Headers, bl4);
        this.listener.onHeadersRead(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4);
    }

    protected EmbeddedChannel newContentDecompressor(ChannelHandlerContext channelHandlerContext, CharSequence charSequence) {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(charSequence)) {
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(charSequence)) {
            ZlibWrapper zlibWrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), ZlibCodecFactory.newZlibDecoder(zlibWrapper));
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence charSequence) {
        return HttpHeaderValues.IDENTITY;
    }

    private void initDecompressor(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, boolean bl3) {
        Http2Stream http2Stream = this.connection.stream(n4);
        if (http2Stream == null) {
            return;
        }
        DelegatingDecompressorFrameListener$Http2Decompressor delegatingDecompressorFrameListener$Http2Decompressor = this.decompressor(http2Stream);
        if (delegatingDecompressorFrameListener$Http2Decompressor == null && !bl3) {
            EmbeddedChannel embeddedChannel;
            CharSequence charSequence = (CharSequence)http2Headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (charSequence == null) {
                charSequence = HttpHeaderValues.IDENTITY;
            }
            if ((embeddedChannel = this.newContentDecompressor(channelHandlerContext, charSequence)) != null) {
                delegatingDecompressorFrameListener$Http2Decompressor = new DelegatingDecompressorFrameListener$Http2Decompressor(embeddedChannel);
                http2Stream.setProperty(this.propertyKey, delegatingDecompressorFrameListener$Http2Decompressor);
                CharSequence charSequence2 = this.getTargetContentEncoding(charSequence);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(charSequence2)) {
                    http2Headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    http2Headers.set(HttpHeaderNames.CONTENT_ENCODING, charSequence2);
                }
            }
        }
        if (delegatingDecompressorFrameListener$Http2Decompressor != null) {
            http2Headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                this.connection.local().flowController(new DelegatingDecompressorFrameListener$ConsumedBytesConverter(this, this.connection.local().flowController()));
            }
        }
    }

    DelegatingDecompressorFrameListener$Http2Decompressor decompressor(Http2Stream http2Stream) {
        return http2Stream == null ? null : (DelegatingDecompressorFrameListener$Http2Decompressor)http2Stream.getProperty(this.propertyKey);
    }

    private static void cleanup(DelegatingDecompressorFrameListener$Http2Decompressor delegatingDecompressorFrameListener$Http2Decompressor) {
        delegatingDecompressorFrameListener$Http2Decompressor.decompressor().finishAndReleaseAll();
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel embeddedChannel) {
        ByteBuf byteBuf;
        while (true) {
            if ((byteBuf = (ByteBuf)embeddedChannel.readInbound()) == null) {
                return null;
            }
            if (byteBuf.isReadable()) break;
            byteBuf.release();
        }
        return byteBuf;
    }

    static /* synthetic */ void access$000(DelegatingDecompressorFrameListener$Http2Decompressor delegatingDecompressorFrameListener$Http2Decompressor) {
        DelegatingDecompressorFrameListener.cleanup(delegatingDecompressorFrameListener$Http2Decompressor);
    }
}

