/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

final class DelegatingDecompressorFrameListener$Http2Decompressor {
    private final EmbeddedChannel decompressor;
    private int compressed;
    private int decompressed;
    static final /* synthetic */ boolean $assertionsDisabled;

    DelegatingDecompressorFrameListener$Http2Decompressor(EmbeddedChannel embeddedChannel) {
        this.decompressor = embeddedChannel;
    }

    EmbeddedChannel decompressor() {
        return this.decompressor;
    }

    void incrementCompressedBytes(int n4) {
        if (!$assertionsDisabled && n4 < 0) {
            throw new AssertionError();
        }
        this.compressed += n4;
    }

    void incrementDecompressedBytes(int n4) {
        if (!$assertionsDisabled && n4 < 0) {
            throw new AssertionError();
        }
        this.decompressed += n4;
    }

    int consumeBytes(int n4, int n7) {
        ObjectUtil.checkPositiveOrZero(n7, "decompressedBytes");
        if (this.decompressed - n7 < 0) {
            throw Http2Exception.streamError(n4, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", n4, this.decompressed, n7);
        }
        double d8 = (double)n7 / (double)this.decompressed;
        int n8 = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * d8));
        if (this.compressed - n8 < 0) {
            throw Http2Exception.streamError(n4, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", n4, n7, this.decompressed, this.compressed, n8);
        }
        this.decompressed -= n7;
        this.compressed -= n8;
        return n8;
    }

    static {
        $assertionsDisabled = !DelegatingDecompressorFrameListener.class.desiredAssertionStatus();
    }
}

