/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.DefaultByteBufHolder;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2UnknownFrame;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public final class DefaultHttp2UnknownFrame
extends DefaultByteBufHolder
implements Http2UnknownFrame {
    private final byte frameType;
    private final Http2Flags flags;
    private Http2FrameStream stream;

    public DefaultHttp2UnknownFrame(byte by2, Http2Flags http2Flags) {
        this(by2, http2Flags, Unpooled.EMPTY_BUFFER);
    }

    public DefaultHttp2UnknownFrame(byte by2, Http2Flags http2Flags, ByteBuf byteBuf) {
        super(byteBuf);
        this.frameType = by2;
        this.flags = http2Flags;
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    @Override
    public DefaultHttp2UnknownFrame stream(Http2FrameStream http2FrameStream) {
        this.stream = http2FrameStream;
        return this;
    }

    @Override
    public byte frameType() {
        return this.frameType;
    }

    @Override
    public Http2Flags flags() {
        return this.flags;
    }

    @Override
    public String name() {
        return "UNKNOWN";
    }

    @Override
    public DefaultHttp2UnknownFrame copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public DefaultHttp2UnknownFrame duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public DefaultHttp2UnknownFrame retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public DefaultHttp2UnknownFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2UnknownFrame(this.frameType, this.flags, byteBuf).stream(this.stream());
    }

    @Override
    public DefaultHttp2UnknownFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public DefaultHttp2UnknownFrame retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(frameType=" + this.frameType() + ", stream=" + this.stream() + ", flags=" + this.flags() + ", content=" + this.contentToString() + ')';
    }

    @Override
    public DefaultHttp2UnknownFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public DefaultHttp2UnknownFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2UnknownFrame)) {
            return false;
        }
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = (DefaultHttp2UnknownFrame)object;
        return super.equals(defaultHttp2UnknownFrame) && this.flags().equals(defaultHttp2UnknownFrame.flags()) && this.frameType() == defaultHttp2UnknownFrame.frameType() && this.stream() == null && defaultHttp2UnknownFrame.stream() == null || this.stream().equals(defaultHttp2UnknownFrame.stream());
    }

    @Override
    public int hashCode() {
        int n4 = super.hashCode();
        n4 = n4 * 31 + this.frameType();
        n4 = n4 * 31 + this.flags().hashCode();
        if (this.stream() != null) {
            n4 = n4 * 31 + this.stream().hashCode();
        }
        return n4;
    }
}

