/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ResetFrame;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public final class DefaultHttp2ResetFrame
extends AbstractHttp2StreamFrame
implements Http2ResetFrame {
    private final long errorCode;

    public DefaultHttp2ResetFrame(Http2Error http2Error) {
        this.errorCode = ObjectUtil.checkNotNull(http2Error, "error").code();
    }

    public DefaultHttp2ResetFrame(long l2) {
        this.errorCode = l2;
    }

    @Override
    public DefaultHttp2ResetFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public String name() {
        return "RST_STREAM";
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(stream=" + this.stream() + ", errorCode=" + this.errorCode + ')';
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2ResetFrame)) {
            return false;
        }
        DefaultHttp2ResetFrame defaultHttp2ResetFrame = (DefaultHttp2ResetFrame)object;
        return super.equals(object) && this.errorCode == defaultHttp2ResetFrame.errorCode;
    }

    @Override
    public int hashCode() {
        int n4 = super.hashCode();
        n4 = n4 * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        return n4;
    }
}

