/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController$FlowState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController$ListenerWritabilityMonitor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController$WritabilityMonitor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController$FlowControlled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController$Listener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2Connection connection;
    private final Http2Connection$PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final DefaultHttp2RemoteFlowController$FlowState connectionState;
    private int initialWindowSize = 65535;
    private DefaultHttp2RemoteFlowController$WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection) {
        this(http2Connection, (Http2RemoteFlowController$Listener)null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor) {
        this(http2Connection, streamByteDistributor, null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, Http2RemoteFlowController$Listener http2RemoteFlowController$Listener) {
        this(http2Connection, new WeightedFairQueueByteDistributor(http2Connection), http2RemoteFlowController$Listener);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController$Listener http2RemoteFlowController$Listener) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.streamByteDistributor = ObjectUtil.checkNotNull(streamByteDistributor, "streamWriteDistributor");
        this.stateKey = http2Connection.newKey();
        this.connectionState = new DefaultHttp2RemoteFlowController$FlowState(this, http2Connection.connectionStream());
        http2Connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener(http2RemoteFlowController$Listener);
        this.monitor.windowSize(this.connectionState, this.initialWindowSize);
        http2Connection.addListener(new DefaultHttp2RemoteFlowController$1(this));
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    @Override
    public void initialWindowSize(int n4) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize(n4);
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public boolean isWritable(Http2Stream http2Stream) {
        return this.monitor.isWritable(this.state(http2Stream));
    }

    @Override
    public void channelWritabilityChanged() {
        this.monitor.channelWritabilityChange();
    }

    @Override
    public void updateDependencyTree(int n4, int n7, short s11, boolean bl3) {
        assert (s11 >= 1 && s11 <= 256) : "Invalid weight";
        assert (n4 != n7) : "A stream cannot depend on itself";
        assert (n4 > 0 && n7 >= 0) : "childStreamId must be > 0. parentStreamId must be >= 0.";
        this.streamByteDistributor.updateDependencyTree(n4, n7, s11, bl3);
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    @Override
    public void listener(Http2RemoteFlowController$Listener http2RemoteFlowController$Listener) {
        this.monitor = http2RemoteFlowController$Listener == null ? new DefaultHttp2RemoteFlowController$WritabilityMonitor(this, null) : new DefaultHttp2RemoteFlowController$ListenerWritabilityMonitor(this, http2RemoteFlowController$Listener);
    }

    @Override
    public void incrementWindowSize(Http2Stream http2Stream, int n4) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state(http2Stream), n4);
    }

    @Override
    public void addFlowControlled(Http2Stream http2Stream, Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(http2RemoteFlowController$FlowControlled, "frame");
        try {
            this.monitor.enqueueFrame(this.state(http2Stream), http2RemoteFlowController$FlowControlled);
        }
        catch (Throwable throwable) {
            http2RemoteFlowController$FlowControlled.error(this.ctx, throwable);
        }
    }

    @Override
    public boolean hasFlowControlled(Http2Stream http2Stream) {
        return this.state(http2Stream).hasFrame();
    }

    private DefaultHttp2RemoteFlowController$FlowState state(Http2Stream http2Stream) {
        return (DefaultHttp2RemoteFlowController$FlowState)http2Stream.getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        int n4 = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        int n7 = n4 > 0 ? Math.max(n4, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), n7);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() {
        this.monitor.writePendingBytes();
    }

    static /* synthetic */ Http2Connection$PropertyKey access$000(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.stateKey;
    }

    static /* synthetic */ DefaultHttp2RemoteFlowController$FlowState access$100(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController, Http2Stream http2Stream) {
        return defaultHttp2RemoteFlowController.state(http2Stream);
    }

    static /* synthetic */ int access$200(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.initialWindowSize;
    }

    static /* synthetic */ DefaultHttp2RemoteFlowController$WritabilityMonitor access$300(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.monitor;
    }

    static /* synthetic */ ChannelHandlerContext access$500(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.ctx;
    }

    static /* synthetic */ StreamByteDistributor access$600(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.streamByteDistributor;
    }

    static /* synthetic */ int access$700(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.connectionWindowSize();
    }

    static /* synthetic */ DefaultHttp2RemoteFlowController$FlowState access$800(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.connectionState;
    }

    static /* synthetic */ int access$900(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.writableBytes();
    }

    static /* synthetic */ boolean access$1000(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.isChannelWritable0();
    }

    static /* synthetic */ int access$202(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController, int n4) {
        defaultHttp2RemoteFlowController.initialWindowSize = n4;
        return defaultHttp2RemoteFlowController.initialWindowSize;
    }

    static /* synthetic */ Http2Connection access$1100(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.connection;
    }

    static /* synthetic */ boolean access$1200(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController) {
        return defaultHttp2RemoteFlowController.isChannelWritable();
    }

    static /* synthetic */ InternalLogger access$1400() {
        return logger;
    }
}

