/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController$FlowControlled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import java.util.ArrayDeque;
import java.util.Deque;

final class DefaultHttp2RemoteFlowController$FlowState
implements StreamByteDistributor$StreamState {
    private final Http2Stream stream;
    private final Deque<Http2RemoteFlowController$FlowControlled> pendingWriteQueue;
    private int window;
    private long pendingBytes;
    private boolean markedWritable;
    private boolean writing;
    private boolean cancelled;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ DefaultHttp2RemoteFlowController this$0;

    DefaultHttp2RemoteFlowController$FlowState(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController, Http2Stream http2Stream) {
        this.this$0 = defaultHttp2RemoteFlowController;
        this.stream = http2Stream;
        this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController$FlowControlled>(2);
    }

    boolean isWritable() {
        return (long)this.windowSize() > this.pendingBytes() && !this.cancelled;
    }

    @Override
    public Http2Stream stream() {
        return this.stream;
    }

    boolean markedWritability() {
        return this.markedWritable;
    }

    void markedWritability(boolean bl3) {
        this.markedWritable = bl3;
    }

    @Override
    public int windowSize() {
        return this.window;
    }

    void windowSize(int n4) {
        this.window = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeAllocatedBytes(int n4) {
        int n7;
        int n8 = n4;
        Throwable throwable = null;
        try {
            int n10;
            Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled;
            if (!$assertionsDisabled && this.writing) {
                throw new AssertionError();
            }
            this.writing = true;
            boolean bl3 = false;
            while (!(this.cancelled || (http2RemoteFlowController$FlowControlled = this.peek()) == null || (n10 = Math.min(n4, this.writableWindow())) <= 0 && http2RemoteFlowController$FlowControlled.size() > 0)) {
                bl3 = true;
                int n11 = http2RemoteFlowController$FlowControlled.size();
                try {
                    http2RemoteFlowController$FlowControlled.write(DefaultHttp2RemoteFlowController.access$500(this.this$0), Math.max(0, n10));
                    if (http2RemoteFlowController$FlowControlled.size() != 0) continue;
                    this.pendingWriteQueue.remove();
                    http2RemoteFlowController$FlowControlled.writeComplete();
                }
                finally {
                    n4 -= n11 - http2RemoteFlowController$FlowControlled.size();
                }
            }
            if (!bl3) {
                n10 = -1;
                return n10;
            }
        }
        catch (Throwable throwable2) {
            this.cancelled = true;
            throwable = throwable2;
        }
        finally {
            this.writing = false;
            int n12 = n8 - n4;
            this.decrementPendingBytes(n12, false);
            this.decrementFlowControlWindow(n12);
            if (this.cancelled) {
                this.cancel(Http2Error.INTERNAL_ERROR, throwable);
            }
        }
        return n7;
    }

    int incrementStreamWindow(int n4) {
        if (n4 > 0 && Integer.MAX_VALUE - n4 < this.window) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
        }
        this.window += n4;
        DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        return this.window;
    }

    private int writableWindow() {
        return Math.min(this.window, DefaultHttp2RemoteFlowController.access$700(this.this$0));
    }

    @Override
    public long pendingBytes() {
        return this.pendingBytes;
    }

    void enqueueFrame(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled2 = this.pendingWriteQueue.peekLast();
        if (http2RemoteFlowController$FlowControlled2 == null) {
            this.enqueueFrameWithoutMerge(http2RemoteFlowController$FlowControlled);
            return;
        }
        int n4 = http2RemoteFlowController$FlowControlled2.size();
        if (http2RemoteFlowController$FlowControlled2.merge(DefaultHttp2RemoteFlowController.access$500(this.this$0), http2RemoteFlowController$FlowControlled)) {
            this.incrementPendingBytes(http2RemoteFlowController$FlowControlled2.size() - n4, true);
            return;
        }
        this.enqueueFrameWithoutMerge(http2RemoteFlowController$FlowControlled);
    }

    private void enqueueFrameWithoutMerge(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        this.pendingWriteQueue.offer(http2RemoteFlowController$FlowControlled);
        this.incrementPendingBytes(http2RemoteFlowController$FlowControlled.size(), true);
    }

    @Override
    public boolean hasFrame() {
        return !this.pendingWriteQueue.isEmpty();
    }

    private Http2RemoteFlowController$FlowControlled peek() {
        return this.pendingWriteQueue.peek();
    }

    void cancel(Http2Error http2Error, Throwable throwable) {
        this.cancelled = true;
        if (this.writing) {
            return;
        }
        Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled = this.pendingWriteQueue.poll();
        if (http2RemoteFlowController$FlowControlled != null) {
            Http2Exception http2Exception = Http2Exception.streamError(this.stream.id(), http2Error, throwable, "Stream closed before write could take place", new Object[0]);
            do {
                this.writeError(http2RemoteFlowController$FlowControlled, http2Exception);
            } while ((http2RemoteFlowController$FlowControlled = this.pendingWriteQueue.poll()) != null);
        }
        DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        DefaultHttp2RemoteFlowController.access$300(this.this$0).stateCancelled(this);
    }

    private void incrementPendingBytes(int n4, boolean bl3) {
        this.pendingBytes += (long)n4;
        DefaultHttp2RemoteFlowController.access$300(this.this$0).incrementPendingBytes(n4);
        if (bl3) {
            DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        }
    }

    private void decrementPendingBytes(int n4, boolean bl3) {
        this.incrementPendingBytes(-n4, bl3);
    }

    private void decrementFlowControlWindow(int n4) {
        try {
            int n7 = -n4;
            DefaultHttp2RemoteFlowController.access$800(this.this$0).incrementStreamWindow(n7);
            this.incrementStreamWindow(n7);
        }
        catch (Http2Exception http2Exception) {
            throw new IllegalStateException("Invalid window state when writing frame: " + http2Exception.getMessage(), http2Exception);
        }
    }

    private void writeError(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled, Http2Exception http2Exception) {
        if (!$assertionsDisabled && DefaultHttp2RemoteFlowController.access$500(this.this$0) == null) {
            throw new AssertionError();
        }
        this.decrementPendingBytes(http2RemoteFlowController$FlowControlled.size(), true);
        http2RemoteFlowController$FlowControlled.error(DefaultHttp2RemoteFlowController.access$500(this.this$0), http2Exception);
    }

    static /* synthetic */ Http2Stream access$1300(DefaultHttp2RemoteFlowController$FlowState defaultHttp2RemoteFlowController$FlowState) {
        return defaultHttp2RemoteFlowController$FlowState.stream;
    }

    static {
        $assertionsDisabled = !DefaultHttp2RemoteFlowController.class.desiredAssertionStatus();
    }
}

