/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$AutoRefillState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$DefaultState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$FlowState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$WindowUpdateVisitor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream$State;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class DefaultHttp2LocalFlowController
implements Http2LocalFlowController {
    public static final float DEFAULT_WINDOW_UPDATE_RATIO = 0.5f;
    private final Http2Connection connection;
    private final Http2Connection$PropertyKey stateKey;
    private Http2FrameWriter frameWriter;
    private ChannelHandlerContext ctx;
    private float windowUpdateRatio;
    private int initialWindowSize = 65535;
    private static final DefaultHttp2LocalFlowController$FlowState REDUCED_FLOW_STATE = new DefaultHttp2LocalFlowController$2();

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection) {
        this(http2Connection, 0.5f, false);
    }

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection, float f8, boolean bl3) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.windowUpdateRatio(f8);
        this.stateKey = http2Connection.newKey();
        DefaultHttp2LocalFlowController$DefaultState defaultHttp2LocalFlowController$DefaultState = bl3 ? new DefaultHttp2LocalFlowController$AutoRefillState(this, http2Connection.connectionStream(), this.initialWindowSize) : new DefaultHttp2LocalFlowController$DefaultState(this, http2Connection.connectionStream(), this.initialWindowSize);
        http2Connection.connectionStream().setProperty(this.stateKey, defaultHttp2LocalFlowController$DefaultState);
        http2Connection.addListener(new DefaultHttp2LocalFlowController$1(this));
    }

    @Override
    public DefaultHttp2LocalFlowController frameWriter(Http2FrameWriter http2FrameWriter) {
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        return this;
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
    }

    @Override
    public void initialWindowSize(int n4) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        int n7 = n4 - this.initialWindowSize;
        this.initialWindowSize = n4;
        DefaultHttp2LocalFlowController$WindowUpdateVisitor defaultHttp2LocalFlowController$WindowUpdateVisitor = new DefaultHttp2LocalFlowController$WindowUpdateVisitor(this, n7);
        this.connection.forEachActiveStream(defaultHttp2LocalFlowController$WindowUpdateVisitor);
        defaultHttp2LocalFlowController$WindowUpdateVisitor.throwIfError();
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public int initialWindowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).initialWindowSize();
    }

    @Override
    public void incrementWindowSize(Http2Stream http2Stream, int n4) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.state(http2Stream);
        defaultHttp2LocalFlowController$FlowState.incrementInitialStreamWindow(n4);
        defaultHttp2LocalFlowController$FlowState.writeWindowUpdateIfNeeded();
    }

    @Override
    public boolean consumeBytes(Http2Stream http2Stream, int n4) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        ObjectUtil.checkPositiveOrZero(n4, "numBytes");
        if (n4 == 0) {
            return false;
        }
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            if (http2Stream.id() == 0) {
                throw new UnsupportedOperationException("Returning bytes for the connection window is not supported");
            }
            boolean bl3 = this.connectionState().consumeBytes(n4);
            return bl3 |= this.state(http2Stream).consumeBytes(n4);
        }
        return false;
    }

    @Override
    public int unconsumedBytes(Http2Stream http2Stream) {
        return this.state(http2Stream).unconsumedBytes();
    }

    private static void checkValidRatio(float f8) {
        if (Double.compare(f8, 0.0) <= 0 || Double.compare(f8, 1.0) >= 0) {
            throw new IllegalArgumentException("Invalid ratio: " + f8);
        }
    }

    public void windowUpdateRatio(float f8) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f8);
        this.windowUpdateRatio = f8;
    }

    public float windowUpdateRatio() {
        return this.windowUpdateRatio;
    }

    public void windowUpdateRatio(Http2Stream http2Stream, float f8) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f8);
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.state(http2Stream);
        defaultHttp2LocalFlowController$FlowState.windowUpdateRatio(f8);
        defaultHttp2LocalFlowController$FlowState.writeWindowUpdateIfNeeded();
    }

    public float windowUpdateRatio(Http2Stream http2Stream) {
        return this.state(http2Stream).windowUpdateRatio();
    }

    @Override
    public void receiveFlowControlledFrame(Http2Stream http2Stream, ByteBuf byteBuf, int n4, boolean bl3) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        int n7 = byteBuf.readableBytes() + n4;
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.connectionState();
        defaultHttp2LocalFlowController$FlowState.receiveFlowControlledFrame(n7);
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState2 = this.state(http2Stream);
            defaultHttp2LocalFlowController$FlowState2.endOfStream(bl3);
            defaultHttp2LocalFlowController$FlowState2.receiveFlowControlledFrame(n7);
        } else if (n7 > 0) {
            defaultHttp2LocalFlowController$FlowState.consumeBytes(n7);
        }
    }

    private DefaultHttp2LocalFlowController$FlowState connectionState() {
        return (DefaultHttp2LocalFlowController$FlowState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private DefaultHttp2LocalFlowController$FlowState state(Http2Stream http2Stream) {
        return (DefaultHttp2LocalFlowController$FlowState)http2Stream.getProperty(this.stateKey);
    }

    private static boolean isClosed(Http2Stream http2Stream) {
        return http2Stream.state() == Http2Stream$State.CLOSED;
    }

    static /* synthetic */ Http2Connection$PropertyKey access$000(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.stateKey;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$100() {
        return REDUCED_FLOW_STATE;
    }

    static /* synthetic */ int access$200(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.initialWindowSize;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$300(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController, Http2Stream http2Stream) {
        return defaultHttp2LocalFlowController.state(http2Stream);
    }

    static /* synthetic */ ChannelHandlerContext access$400(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.ctx;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$500(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.connectionState();
    }

    static /* synthetic */ float access$600(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.windowUpdateRatio;
    }

    static /* synthetic */ Http2FrameWriter access$700(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.frameWriter;
    }
}

