/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$FlowState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;

class DefaultHttp2LocalFlowController$DefaultState
implements DefaultHttp2LocalFlowController$FlowState {
    private final Http2Stream stream;
    private int window;
    private int processedWindow;
    private int initialStreamWindowSize;
    private float streamWindowUpdateRatio;
    private int lowerBound;
    private boolean endOfStream;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ DefaultHttp2LocalFlowController this$0;

    DefaultHttp2LocalFlowController$DefaultState(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController, Http2Stream http2Stream, int n4) {
        this.this$0 = defaultHttp2LocalFlowController;
        this.stream = http2Stream;
        this.window(n4);
        this.streamWindowUpdateRatio = DefaultHttp2LocalFlowController.access$600(defaultHttp2LocalFlowController);
    }

    @Override
    public void window(int n4) {
        if (!$assertionsDisabled && DefaultHttp2LocalFlowController.access$400(this.this$0) != null && !DefaultHttp2LocalFlowController.access$400(this.this$0).executor().inEventLoop()) {
            throw new AssertionError();
        }
        this.processedWindow = this.initialStreamWindowSize = n4;
        this.window = this.initialStreamWindowSize;
    }

    @Override
    public int windowSize() {
        return this.window;
    }

    @Override
    public int initialWindowSize() {
        return this.initialStreamWindowSize;
    }

    @Override
    public void endOfStream(boolean bl3) {
        this.endOfStream = bl3;
    }

    @Override
    public float windowUpdateRatio() {
        return this.streamWindowUpdateRatio;
    }

    @Override
    public void windowUpdateRatio(float f8) {
        if (!$assertionsDisabled && DefaultHttp2LocalFlowController.access$400(this.this$0) != null && !DefaultHttp2LocalFlowController.access$400(this.this$0).executor().inEventLoop()) {
            throw new AssertionError();
        }
        this.streamWindowUpdateRatio = f8;
    }

    @Override
    public void incrementInitialStreamWindow(int n4) {
        int n7 = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, (long)this.initialStreamWindowSize + (long)n4));
        n4 = n7 - this.initialStreamWindowSize;
        this.initialStreamWindowSize += n4;
    }

    @Override
    public void incrementFlowControlWindows(int n4) {
        if (n4 > 0 && this.window > Integer.MAX_VALUE - n4) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window overflowed for stream: %d", this.stream.id());
        }
        this.window += n4;
        this.processedWindow += n4;
        this.lowerBound = n4 < 0 ? n4 : 0;
    }

    @Override
    public void receiveFlowControlledFrame(int n4) {
        if (!$assertionsDisabled && n4 < 0) {
            throw new AssertionError();
        }
        this.window -= n4;
        if (this.window < this.lowerBound) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window exceeded for stream: %d", this.stream.id());
        }
    }

    private void returnProcessedBytes(int n4) {
        if (this.processedWindow - n4 < this.window) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d", this.stream.id());
        }
        this.processedWindow -= n4;
    }

    @Override
    public boolean consumeBytes(int n4) {
        this.returnProcessedBytes(n4);
        return this.writeWindowUpdateIfNeeded();
    }

    @Override
    public int unconsumedBytes() {
        return this.processedWindow - this.window;
    }

    @Override
    public boolean writeWindowUpdateIfNeeded() {
        if (this.endOfStream || this.initialStreamWindowSize <= 0) {
            return false;
        }
        int n4 = (int)((float)this.initialStreamWindowSize * this.streamWindowUpdateRatio);
        if (this.processedWindow <= n4) {
            this.writeWindowUpdate();
            return true;
        }
        return false;
    }

    private void writeWindowUpdate() {
        int n4 = this.initialStreamWindowSize - this.processedWindow;
        try {
            this.incrementFlowControlWindows(n4);
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Attempting to return too many bytes for stream %d", this.stream.id());
        }
        DefaultHttp2LocalFlowController.access$700(this.this$0).writeWindowUpdate(DefaultHttp2LocalFlowController.access$400(this.this$0), this.stream.id(), n4, DefaultHttp2LocalFlowController.access$400(this.this$0).newPromise());
    }

    static {
        $assertionsDisabled = !DefaultHttp2LocalFlowController.class.desiredAssertionStatus();
    }
}

