/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public final class DefaultHttp2HeadersFrame
extends AbstractHttp2StreamFrame
implements Http2HeadersFrame {
    private final Http2Headers headers;
    private final boolean endStream;
    private final int padding;

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers) {
        this(http2Headers, false);
    }

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers, boolean bl3) {
        this(http2Headers, bl3, 0);
    }

    public DefaultHttp2HeadersFrame(Http2Headers http2Headers, boolean bl3, int n4) {
        this.headers = ObjectUtil.checkNotNull(http2Headers, "headers");
        this.endStream = bl3;
        Http2CodecUtil.verifyPadding(n4);
        this.padding = n4;
    }

    @Override
    public DefaultHttp2HeadersFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public String name() {
        return "HEADERS";
    }

    @Override
    public Http2Headers headers() {
        return this.headers;
    }

    @Override
    public boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public int padding() {
        return this.padding;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(stream=" + this.stream() + ", headers=" + this.headers + ", endStream=" + this.endStream + ", padding=" + this.padding + ')';
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2HeadersFrame)) {
            return false;
        }
        DefaultHttp2HeadersFrame defaultHttp2HeadersFrame = (DefaultHttp2HeadersFrame)object;
        return super.equals(defaultHttp2HeadersFrame) && this.headers.equals(defaultHttp2HeadersFrame.headers) && this.endStream == defaultHttp2HeadersFrame.endStream && this.padding == defaultHttp2HeadersFrame.padding;
    }

    @Override
    public int hashCode() {
        int n4 = super.hashCode();
        n4 = n4 * 31 + this.headers.hashCode();
        n4 = n4 * 31 + (this.endStream ? 0 : 1);
        n4 = n4 * 31 + this.padding;
        return n4;
    }
}

