/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HpackEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder$Configuration {
    private final HpackEncoder hpackEncoder;
    private final Http2HeadersEncoder$SensitivityDetector sensitivityDetector;
    private final ByteBuf tableSizeChangeOutput = Unpooled.buffer();

    public DefaultHttp2HeadersEncoder() {
        this(NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder());
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl3) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder(bl3));
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl3, int n4) {
        this(http2HeadersEncoder$SensitivityDetector, bl3, n4, 512);
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl3, int n4, int n7) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder(bl3, n4, n7));
    }

    DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, HpackEncoder hpackEncoder) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(http2HeadersEncoder$SensitivityDetector, "sensitiveDetector");
        this.hpackEncoder = ObjectUtil.checkNotNull(hpackEncoder, "hpackEncoder");
    }

    @Override
    public void encodeHeaders(int n4, Http2Headers http2Headers, ByteBuf byteBuf) {
        try {
            if (this.tableSizeChangeOutput.isReadable()) {
                byteBuf.writeBytes(this.tableSizeChangeOutput);
                this.tableSizeChangeOutput.clear();
            }
            this.hpackEncoder.encodeHeaders(n4, byteBuf, http2Headers, this.sensitivityDetector);
        }
        catch (Http2Exception http2Exception) {
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable, "Failed encoding headers block: %s", throwable.getMessage());
        }
    }

    @Override
    public void maxHeaderTableSize(long l2) {
        this.hpackEncoder.setMaxHeaderTableSize(this.tableSizeChangeOutput, l2);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.hpackEncoder.getMaxHeaderTableSize();
    }

    @Override
    public void maxHeaderListSize(long l2) {
        this.hpackEncoder.setMaxHeaderListSize(l2);
    }

    @Override
    public long maxHeaderListSize() {
        return this.hpackEncoder.getMaxHeaderListSize();
    }

    @Override
    public Http2HeadersEncoder$Configuration configuration() {
        return this;
    }
}

