/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.DefaultByteBufHolder;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public final class DefaultHttp2GoAwayFrame
extends DefaultByteBufHolder
implements Http2GoAwayFrame {
    private final long errorCode;
    private final int lastStreamId;
    private int extraStreamIds;

    public DefaultHttp2GoAwayFrame(Http2Error http2Error) {
        this(http2Error.code());
    }

    public DefaultHttp2GoAwayFrame(long l2) {
        this(l2, Unpooled.EMPTY_BUFFER);
    }

    public DefaultHttp2GoAwayFrame(Http2Error http2Error, ByteBuf byteBuf) {
        this(http2Error.code(), byteBuf);
    }

    public DefaultHttp2GoAwayFrame(long l2, ByteBuf byteBuf) {
        this(-1, l2, byteBuf);
    }

    DefaultHttp2GoAwayFrame(int n4, long l2, ByteBuf byteBuf) {
        super(byteBuf);
        this.errorCode = l2;
        this.lastStreamId = n4;
    }

    @Override
    public String name() {
        return "GOAWAY";
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    @Override
    public int extraStreamIds() {
        return this.extraStreamIds;
    }

    @Override
    public Http2GoAwayFrame setExtraStreamIds(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "extraStreamIds");
        this.extraStreamIds = n4;
        return this;
    }

    @Override
    public int lastStreamId() {
        return this.lastStreamId;
    }

    @Override
    public Http2GoAwayFrame copy() {
        return new DefaultHttp2GoAwayFrame(this.lastStreamId, this.errorCode, this.content().copy());
    }

    @Override
    public Http2GoAwayFrame duplicate() {
        return (Http2GoAwayFrame)super.duplicate();
    }

    @Override
    public Http2GoAwayFrame retainedDuplicate() {
        return (Http2GoAwayFrame)super.retainedDuplicate();
    }

    @Override
    public Http2GoAwayFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2GoAwayFrame(this.errorCode, byteBuf).setExtraStreamIds(this.extraStreamIds);
    }

    @Override
    public Http2GoAwayFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public Http2GoAwayFrame retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public Http2GoAwayFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public Http2GoAwayFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        DefaultHttp2GoAwayFrame defaultHttp2GoAwayFrame = (DefaultHttp2GoAwayFrame)object;
        return this.errorCode == defaultHttp2GoAwayFrame.errorCode && this.extraStreamIds == defaultHttp2GoAwayFrame.extraStreamIds && super.equals(defaultHttp2GoAwayFrame);
    }

    @Override
    public int hashCode() {
        int n4 = super.hashCode();
        n4 = n4 * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        n4 = n4 * 31 + this.extraStreamIds;
        return n4;
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + "(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ", lastStreamId=" + this.lastStreamId + ')';
    }
}

