/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil$SimpleChannelPromiseAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.collection.CharObjectMap$PrimitiveEntry;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameWriter
implements Http2FrameSizePolicy,
Http2FrameWriter,
Http2FrameWriter$Configuration {
    private static final String STREAM_ID = "Stream ID";
    private static final String STREAM_DEPENDENCY = "Stream Dependency";
    private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer(Unpooled.directBuffer(255).writeZero(255)).asReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        this(new DefaultHttp2HeadersEncoder(http2HeadersEncoder$SensitivityDetector));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl3) {
        this(new DefaultHttp2HeadersEncoder(http2HeadersEncoder$SensitivityDetector, bl3));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder http2HeadersEncoder) {
        this.headersEncoder = http2HeadersEncoder;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this;
    }

    @Override
    public Http2HeadersEncoder$Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    @Override
    public void maxFrameSize(int n4) {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n4)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n4);
        }
        this.maxFrameSize = n4;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        ReferenceCounted referenceCounted = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n4, STREAM_ID);
            Http2CodecUtil.verifyPadding(n7);
            int n8 = byteBuf.readableBytes();
            Http2Flags http2Flags = new Http2Flags();
            http2Flags.endOfStream(false);
            http2Flags.paddingPresent(false);
            if (n8 > this.maxFrameSize) {
                referenceCounted = channelHandlerContext.alloc().buffer(9);
                Http2CodecUtil.writeFrameHeaderInternal((ByteBuf)referenceCounted, this.maxFrameSize, (byte)0, http2Flags, n4);
                do {
                    channelHandlerContext.write(((ByteBuf)referenceCounted).retainedSlice(), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    channelHandlerContext.write(byteBuf.readRetainedSlice(this.maxFrameSize), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } while ((n8 -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (n7 == 0) {
                if (referenceCounted != null) {
                    referenceCounted.release();
                    referenceCounted = null;
                }
                ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
                http2Flags.endOfStream(bl3);
                Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n8, (byte)0, http2Flags, n4);
                channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                ByteBuf byteBuf3 = byteBuf.readSlice(n8);
                byteBuf = null;
                channelHandlerContext.write(byteBuf3, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            } else {
                if (n8 != this.maxFrameSize) {
                    if (referenceCounted != null) {
                        referenceCounted.release();
                        referenceCounted = null;
                    }
                } else {
                    ByteBuf byteBuf4;
                    n8 -= this.maxFrameSize;
                    if (referenceCounted == null) {
                        byteBuf4 = channelHandlerContext.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(byteBuf4, this.maxFrameSize, (byte)0, http2Flags, n4);
                    } else {
                        byteBuf4 = ((ByteBuf)referenceCounted).slice();
                        referenceCounted = null;
                    }
                    channelHandlerContext.write(byteBuf4, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    byteBuf4 = byteBuf.readableBytes() != this.maxFrameSize ? byteBuf.readSlice(this.maxFrameSize) : byteBuf;
                    byteBuf = null;
                    channelHandlerContext.write(byteBuf4, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                }
                do {
                    int n10 = Math.min(n8, this.maxFrameSize);
                    int n11 = Math.min(n7, Math.max(0, this.maxFrameSize - 1 - n10));
                    ByteBuf byteBuf5 = channelHandlerContext.alloc().buffer(10);
                    http2Flags.endOfStream(bl3 && (n8 -= n10) == 0 && (n7 -= n11) == 0);
                    http2Flags.paddingPresent(n11 > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf5, n11 + n10, (byte)0, http2Flags, n4);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf5, n11);
                    channelHandlerContext.write(byteBuf5, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    if (n10 != 0) {
                        if (n8 == 0) {
                            ByteBuf byteBuf6 = byteBuf.readSlice(n10);
                            byteBuf = null;
                            channelHandlerContext.write(byteBuf6, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                        } else {
                            channelHandlerContext.write(byteBuf.readRetainedSlice(n10), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(n11) <= 0) continue;
                    channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n11)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } while (n8 != 0 || n7 != 0);
            }
        }
        catch (Throwable throwable) {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
            try {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n4, http2Headers, n7, bl3, false, 0, (short)0, false, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n4, http2Headers, n8, bl4, true, n7, s11, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n4, int n7, short s11, boolean bl3, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n4, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(n7, STREAM_DEPENDENCY);
            DefaultHttp2FrameWriter.verifyWeight(s11);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 5, (byte)2, new Http2Flags(), n4);
            byteBuf.writeInt(bl3 ? (int)(0x80000000L | (long)n7) : n7);
            byteBuf.writeByte(s11 - 1);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n4, STREAM_ID);
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)3, new Http2Flags(), n4);
            byteBuf.writeInt((int)l2);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        try {
            ObjectUtil.checkNotNull(http2Settings, "settings");
            int n4 = 6 * http2Settings.size();
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9 + http2Settings.size() * 6);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, n4, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap$PrimitiveEntry charObjectMap$PrimitiveEntry : http2Settings.entries()) {
                byteBuf.writeChar(charObjectMap$PrimitiveEntry.key());
                byteBuf.writeInt(((Long)charObjectMap$PrimitiveEntry.value()).intValue());
            }
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        try {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl3, long l2, ChannelPromise channelPromise) {
        Http2Flags http2Flags = bl3 ? new Http2Flags().ack(true) : new Http2Flags();
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer(17);
        Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 8, (byte)6, http2Flags, 0);
        byteBuf.writeLong(l2);
        return channelHandlerContext.write(byteBuf, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n4, int n7, Http2Headers http2Headers, int n8, ChannelPromise channelPromise) {
        ReferenceCounted referenceCounted = null;
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n4, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(n7, "Promised Stream ID");
            Http2CodecUtil.verifyPadding(n8);
            referenceCounted = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n4, http2Headers, (ByteBuf)referenceCounted);
            Http2Flags http2Flags = new Http2Flags().paddingPresent(n8 > 0);
            int n10 = 4 + n8;
            int n11 = this.maxFrameSize - n10;
            ByteBuf byteBuf = ((ByteBuf)referenceCounted).readRetainedSlice(Math.min(((ByteBuf)referenceCounted).readableBytes(), n11));
            http2Flags.endOfHeaders(!((ByteBuf)referenceCounted).isReadable());
            int n12 = byteBuf.readableBytes() + n10;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n12, (byte)5, http2Flags, n4);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n8);
            byteBuf2.writeInt(n7);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n8) > 0) {
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n8)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n4, (ByteBuf)referenceCounted, n8, http2CodecUtil$SimpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
            http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException(throwable);
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n4, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            int n7 = 8 + byteBuf.readableBytes();
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(17);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n7, (byte)7, new Http2Flags(), 0);
            byteBuf2.writeInt(n4);
            byteBuf2.writeInt((int)l2);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n4, int n7, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n4, STREAM_ID);
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(n7);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)8, new Http2Flags(), n4);
            byteBuf.writeInt(n7);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n4, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n4, STREAM_ID);
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, byteBuf.readableBytes(), by2, http2Flags, n4);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture writeHeadersInternal(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, boolean bl4, int n8, short s11, boolean bl5, ChannelPromise channelPromise) {
        ReferenceCounted referenceCounted = null;
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n4, STREAM_ID);
            if (bl4) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n8, STREAM_DEPENDENCY);
                Http2CodecUtil.verifyPadding(n7);
                DefaultHttp2FrameWriter.verifyWeight(s11);
            }
            referenceCounted = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n4, http2Headers, (ByteBuf)referenceCounted);
            Http2Flags http2Flags = new Http2Flags().endOfStream(bl3).priorityPresent(bl4).paddingPresent(n7 > 0);
            int n10 = n7 + http2Flags.getNumPriorityBytes();
            int n11 = this.maxFrameSize - n10;
            ByteBuf byteBuf = ((ByteBuf)referenceCounted).readRetainedSlice(Math.min(((ByteBuf)referenceCounted).readableBytes(), n11));
            http2Flags.endOfHeaders(!((ByteBuf)referenceCounted).isReadable());
            int n12 = byteBuf.readableBytes() + n10;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(15);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n12, (byte)1, http2Flags, n4);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n7);
            if (bl4) {
                byteBuf2.writeInt(bl5 ? (int)(0x80000000L | (long)n8) : n8);
                byteBuf2.writeByte(s11 - 1);
            }
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n7) > 0) {
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n7)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n4, (ByteBuf)referenceCounted, n7, http2CodecUtil$SimpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
            http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException(throwable);
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    private ChannelFuture writeContinuationFrames(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator) {
        Http2Flags http2Flags = new Http2Flags().paddingPresent(n7 > 0);
        int n8 = this.maxFrameSize - n7;
        if (n8 <= 0) {
            return http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(new IllegalArgumentException("Padding [" + n7 + "] is too large for max frame size [" + this.maxFrameSize + "]"));
        }
        if (byteBuf.isReadable()) {
            int n10 = Math.min(byteBuf.readableBytes(), n8);
            int n11 = n10 + n7;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(10);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n11, (byte)9, http2Flags, n4);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n7);
            do {
                n10 = Math.min(byteBuf.readableBytes(), n8);
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n10);
                n11 = n10 + n7;
                if (byteBuf.isReadable()) {
                    channelHandlerContext.write(byteBuf2.retain(), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } else {
                    http2Flags = http2Flags.endOfHeaders(true);
                    byteBuf2.release();
                    byteBuf2 = channelHandlerContext.alloc().buffer(10);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n11, (byte)9, http2Flags, n4);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n7);
                    channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                }
                channelHandlerContext.write(byteBuf3, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                if (DefaultHttp2FrameWriter.paddingBytes(n7) <= 0) continue;
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n7)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            } while (byteBuf.isReadable());
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator;
    }

    private static int paddingBytes(int n4) {
        return n4 - 1;
    }

    private static void writePaddingLength(ByteBuf byteBuf, int n4) {
        if (n4 > 0) {
            byteBuf.writeByte(n4 - 1);
        }
    }

    private static void verifyStreamId(int n4, String string) {
        ObjectUtil.checkPositive(n4, "streamId");
    }

    private static void verifyStreamOrConnectionId(int n4, String string) {
        ObjectUtil.checkPositiveOrZero(n4, "streamId");
    }

    private static void verifyWeight(short s11) {
        if (s11 < 1 || s11 > 256) {
            throw new IllegalArgumentException("Invalid weight: " + s11);
        }
    }

    private static void verifyErrorCode(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid errorCode: " + l2);
        }
    }

    private static void verifyWindowSizeIncrement(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "windowSizeIncrement");
    }

    private static void verifyPingPayload(ByteBuf byteBuf) {
        if (byteBuf == null || byteBuf.readableBytes() != 8) {
            throw new IllegalArgumentException("Opaque data must be 8 bytes");
        }
    }
}

