/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledData;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil$SimpleChannelPromiseAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LifecycleManager;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Queue<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque<Http2Settings>(4);
    private Queue<Http2Settings> outstandingRemoteSettingsQueue;

    public DefaultHttp2ConnectionEncoder(Http2Connection http2Connection, Http2FrameWriter http2FrameWriter) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        if (http2Connection.remote().flowController() == null) {
            http2Connection.remote().flowController(new DefaultHttp2RemoteFlowController(http2Connection));
        }
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    @Override
    public void remoteSettings(Http2Settings http2Settings) {
        Integer n4;
        Integer n7;
        Long l2;
        Long l10;
        Long l11;
        Boolean bl3 = http2Settings.pushEnabled();
        Http2FrameWriter$Configuration http2FrameWriter$Configuration = this.configuration();
        Http2HeadersEncoder$Configuration http2HeadersEncoder$Configuration = http2FrameWriter$Configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = http2FrameWriter$Configuration.frameSizePolicy();
        if (bl3 != null) {
            if (!this.connection.isServer() && bl3.booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo(bl3);
        }
        if ((l11 = http2Settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(l11, Integer.MAX_VALUE));
        }
        if ((l10 = http2Settings.headerTableSize()) != null) {
            http2HeadersEncoder$Configuration.maxHeaderTableSize((int)Math.min(l10, Integer.MAX_VALUE));
        }
        if ((l2 = http2Settings.maxHeaderListSize()) != null) {
            http2HeadersEncoder$Configuration.maxHeaderListSize(l2);
        }
        if ((n7 = http2Settings.maxFrameSize()) != null) {
            http2FrameSizePolicy.maxFrameSize(n7);
        }
        if ((n4 = http2Settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(n4);
        }
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3, ChannelPromise channelPromise) {
        Http2Stream http2Stream;
        try {
            http2Stream = this.requireStream(n4);
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                }
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            return channelPromise.setFailure(throwable);
        }
        this.flowController().addFlowControlled(http2Stream, new DefaultHttp2ConnectionEncoder$FlowControlledData(this, http2Stream, byteBuf, n7, bl3, channelPromise));
        return channelPromise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, ChannelPromise channelPromise) {
        return this.writeHeaders(channelHandlerContext, n4, http2Headers, 0, (short)16, false, n7, bl3, channelPromise);
    }

    private static boolean validateHeadersSentState(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = bl5 = bl3 && HttpStatusClass.valueOf(http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((bl5 || !bl4) && http2Stream.isHeadersSent() || http2Stream.isTrailersSent()) {
            throw new IllegalStateException("Stream " + http2Stream.id() + " sent too many headers EOS: " + bl4);
        }
        return bl5;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4, ChannelPromise channelPromise) {
        try {
            Http2Stream http2Stream = this.connection.stream(n4);
            if (http2Stream == null) {
                try {
                    http2Stream = this.connection.local().createStream(n4, false);
                }
                catch (Http2Exception http2Exception) {
                    if (this.connection.remote().mayHaveCreatedStream(n4)) {
                        channelPromise.tryFailure(new IllegalStateException("Stream no longer exists: " + n4, http2Exception));
                        return channelPromise;
                    }
                    throw http2Exception;
                }
            } else {
                switch (http2Stream.state()) {
                    case RESERVED_LOCAL: {
                        http2Stream.open(bl4);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                    }
                }
            }
            Http2RemoteFlowController http2RemoteFlowController = this.flowController();
            if (!bl4 || !http2RemoteFlowController.hasFlowControlled(http2Stream)) {
                channelPromise = channelPromise.unvoid();
                boolean bl5 = DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, http2Headers, this.connection.isServer(), bl4);
                ChannelFuture channelFuture = this.frameWriter.writeHeaders(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4, channelPromise);
                Throwable throwable = channelFuture.cause();
                if (throwable == null) {
                    http2Stream.headersSent(bl5);
                    if (!channelFuture.isSuccess()) {
                        this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                    }
                } else {
                    this.lifecycleManager.onError(channelHandlerContext, true, throwable);
                }
                if (bl4) {
                    this.lifecycleManager.closeStreamLocal(http2Stream, channelFuture);
                }
                return channelFuture;
            }
            http2RemoteFlowController.addFlowControlled(http2Stream, new DefaultHttp2ConnectionEncoder$FlowControlledHeaders(this, http2Stream, http2Headers, n7, s11, bl3, n8, true, channelPromise));
            return channelPromise;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n4, int n7, short s11, boolean bl3, ChannelPromise channelPromise) {
        return this.frameWriter.writePriority(channelHandlerContext, n4, n7, s11, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        return this.lifecycleManager.resetStream(channelHandlerContext, n4, l2, channelPromise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.outstandingLocalSettingsQueue.add(http2Settings);
        try {
            Boolean bl3 = http2Settings.pushEnabled();
            if (bl3 != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
        return this.frameWriter.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.outstandingRemoteSettingsQueue == null) {
            return this.frameWriter.writeSettingsAck(channelHandlerContext, channelPromise);
        }
        Http2Settings http2Settings = this.outstandingRemoteSettingsQueue.poll();
        if (http2Settings == null) {
            return channelPromise.setFailure(new Http2Exception(Http2Error.INTERNAL_ERROR, "attempted to write a SETTINGS ACK with no  pending SETTINGS"));
        }
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        this.frameWriter.writeSettingsAck(channelHandlerContext, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        ChannelPromise channelPromise2 = http2CodecUtil$SimpleChannelPromiseAggregator.newPromise();
        try {
            this.remoteSettings(http2Settings);
            channelPromise2.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise2.setFailure(throwable);
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl3, long l2, ChannelPromise channelPromise) {
        return this.frameWriter.writePing(channelHandlerContext, bl3, l2, channelPromise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n4, int n7, Http2Headers http2Headers, int n8, ChannelPromise channelPromise) {
        try {
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream http2Stream = this.requireStream(n4);
            this.connection.local().reservePushStream(n7, http2Stream);
            channelPromise = channelPromise.unvoid();
            ChannelFuture channelFuture = this.frameWriter.writePushPromise(channelHandlerContext, n4, n7, http2Headers, n8, channelPromise);
            Throwable throwable = channelFuture.cause();
            if (throwable == null) {
                http2Stream.pushPromiseSent();
                if (!channelFuture.isSuccess()) {
                    this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                }
            } else {
                this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            }
            return channelFuture;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.lifecycleManager.goAway(channelHandlerContext, n4, l2, byteBuf, channelPromise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n4, int n7, ChannelPromise channelPromise) {
        return channelPromise.setFailure(new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n4, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.frameWriter.writeFrame(channelHandlerContext, by2, n4, http2Flags, byteBuf, channelPromise);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int n4) {
        Http2Stream http2Stream = this.connection.stream(n4);
        if (http2Stream == null) {
            String string = this.connection.streamMayHaveExisted(n4) ? "Stream no longer exists: " + n4 : "Stream does not exist: " + n4;
            throw new IllegalArgumentException(string);
        }
        return http2Stream;
    }

    @Override
    public void consumeReceivedSettings(Http2Settings http2Settings) {
        if (this.outstandingRemoteSettingsQueue == null) {
            this.outstandingRemoteSettingsQueue = new ArrayDeque<Http2Settings>(2);
        }
        this.outstandingRemoteSettingsQueue.add(http2Settings);
    }

    private void notifyLifecycleManagerOnError(ChannelFuture channelFuture, ChannelHandlerContext channelHandlerContext) {
        channelFuture.addListener(new DefaultHttp2ConnectionEncoder$1(this, channelHandlerContext));
    }

    static /* synthetic */ Http2LifecycleManager access$000(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.lifecycleManager;
    }

    static /* synthetic */ Http2Connection access$100(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.connection;
    }

    static /* synthetic */ boolean access$200(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl3, boolean bl4) {
        return DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, http2Headers, bl3, bl4);
    }

    static /* synthetic */ Http2FrameWriter access$300(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.frameWriter;
    }
}

