/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.CoalescingBufferQueue;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledBase;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController$FlowControlled;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;

final class DefaultHttp2ConnectionEncoder$FlowControlledData
extends DefaultHttp2ConnectionEncoder$FlowControlledBase {
    private final CoalescingBufferQueue queue;
    private int dataSize;
    final /* synthetic */ DefaultHttp2ConnectionEncoder this$0;

    DefaultHttp2ConnectionEncoder$FlowControlledData(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder, Http2Stream http2Stream, ByteBuf byteBuf, int n4, boolean bl3, ChannelPromise channelPromise) {
        this.this$0 = defaultHttp2ConnectionEncoder;
        super(defaultHttp2ConnectionEncoder, http2Stream, n4, bl3, channelPromise);
        this.queue = new CoalescingBufferQueue(channelPromise.channel());
        this.queue.add(byteBuf, channelPromise);
        this.dataSize = this.queue.readableBytes();
    }

    @Override
    public int size() {
        return this.dataSize + this.padding;
    }

    @Override
    public void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.queue.releaseAndFailAll(throwable);
        DefaultHttp2ConnectionEncoder.access$000(this.this$0).onError(channelHandlerContext, true, throwable);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, int n4) {
        int n7 = this.queue.readableBytes();
        if (!this.endOfStream) {
            if (n7 == 0) {
                if (this.queue.isEmpty()) {
                    this.dataSize = 0;
                    this.padding = 0;
                } else {
                    ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
                    channelHandlerContext.write(this.queue.remove(0, channelPromise), channelPromise);
                }
                return;
            }
            if (n4 == 0) {
                return;
            }
        }
        int n8 = Math.min(n7, n4);
        ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
        ByteBuf byteBuf = this.queue.remove(n8, channelPromise);
        this.dataSize = this.queue.readableBytes();
        int n10 = Math.min(n4 - n8, this.padding);
        this.padding -= n10;
        this.this$0.frameWriter().writeData(channelHandlerContext, this.stream.id(), byteBuf, n10, this.endOfStream && this.size() == 0, channelPromise);
    }

    @Override
    public boolean merge(ChannelHandlerContext channelHandlerContext, Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        DefaultHttp2ConnectionEncoder$FlowControlledData defaultHttp2ConnectionEncoder$FlowControlledData;
        if (DefaultHttp2ConnectionEncoder$FlowControlledData.class != http2RemoteFlowController$FlowControlled.getClass() || Integer.MAX_VALUE - (defaultHttp2ConnectionEncoder$FlowControlledData = (DefaultHttp2ConnectionEncoder$FlowControlledData)http2RemoteFlowController$FlowControlled).size() < this.size()) {
            return false;
        }
        defaultHttp2ConnectionEncoder$FlowControlledData.queue.copyTo(this.queue);
        this.dataSize = this.queue.readableBytes();
        this.padding = Math.max(this.padding, defaultHttp2ConnectionEncoder$FlowControlledData.padding);
        this.endOfStream = defaultHttp2ConnectionEncoder$FlowControlledData.endOfStream;
        return true;
    }
}

