/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder$FrameReadListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder$PrefaceFrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameReader;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameReader$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersDecoder$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LifecycleManager;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new DefaultHttp2ConnectionDecoder$PrefaceFrameListener(this, null);
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;
    private final Http2SettingsReceivedConsumer settingsReceivedConsumer;
    private final boolean autoAckPing;

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl3) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, http2PromisedRequestVerifier, bl3, true);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier, boolean bl3, boolean bl4) {
        this.autoAckPing = bl4;
        if (bl3) {
            this.settingsReceivedConsumer = null;
        } else {
            if (!(http2ConnectionEncoder instanceof Http2SettingsReceivedConsumer)) {
                throw new IllegalArgumentException("disabling autoAckSettings requires the encoder to be a " + Http2SettingsReceivedConsumer.class);
            }
            this.settingsReceivedConsumer = (Http2SettingsReceivedConsumer)((Object)http2ConnectionEncoder);
        }
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameReader = ObjectUtil.checkNotNull(http2FrameReader, "frameReader");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.requestVerifier = ObjectUtil.checkNotNull(http2PromisedRequestVerifier, "requestVerifier");
        if (http2Connection.local().flowController() == null) {
            http2Connection.local().flowController(new DefaultHttp2LocalFlowController(http2Connection));
        }
        http2Connection.local().flowController().frameWriter(http2ConnectionEncoder.frameWriter());
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    @Override
    public void frameListener(Http2FrameListener http2FrameListener) {
        this.listener = ObjectUtil.checkNotNull(http2FrameListener, "listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    Http2FrameListener internalFrameListener() {
        return this.internalFrameListener;
    }

    @Override
    public boolean prefaceReceived() {
        return DefaultHttp2ConnectionDecoder$FrameReadListener.class == this.internalFrameListener.getClass();
    }

    @Override
    public void decodeFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.frameReader.readFrame(channelHandlerContext, byteBuf, this.internalFrameListener);
    }

    @Override
    public Http2Settings localSettings() {
        Http2Settings http2Settings = new Http2Settings();
        Http2FrameReader$Configuration http2FrameReader$Configuration = this.frameReader.configuration();
        Http2HeadersDecoder$Configuration http2HeadersDecoder$Configuration = http2FrameReader$Configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = http2FrameReader$Configuration.frameSizePolicy();
        http2Settings.initialWindowSize(this.flowController().initialWindowSize());
        http2Settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        http2Settings.headerTableSize(http2HeadersDecoder$Configuration.maxHeaderTableSize());
        http2Settings.maxFrameSize(http2FrameSizePolicy.maxFrameSize());
        http2Settings.maxHeaderListSize(http2HeadersDecoder$Configuration.maxHeaderListSize());
        if (!this.connection.isServer()) {
            http2Settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return http2Settings;
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long l2) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway(l2);
    }

    private int unconsumedBytes(Http2Stream http2Stream) {
        return this.flowController().unconsumedBytes(http2Stream);
    }

    void onGoAwayRead0(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf) {
        this.connection.goAwayReceived(n4, l2, byteBuf);
        this.listener.onGoAwayRead(channelHandlerContext, n4, l2, byteBuf);
    }

    void onUnknownFrame0(ChannelHandlerContext channelHandlerContext, byte by2, int n4, Http2Flags http2Flags, ByteBuf byteBuf) {
        this.listener.onUnknownFrame(channelHandlerContext, by2, n4, http2Flags, byteBuf);
    }

    static /* synthetic */ Http2Connection access$100(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.connection;
    }

    static /* synthetic */ int access$200(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder, Http2Stream http2Stream) {
        return defaultHttp2ConnectionDecoder.unconsumedBytes(http2Stream);
    }

    static /* synthetic */ Http2FrameListener access$300(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.listener;
    }

    static /* synthetic */ Http2LifecycleManager access$400(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.lifecycleManager;
    }

    static /* synthetic */ Http2ConnectionEncoder access$500(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.encoder;
    }

    static /* synthetic */ Http2FrameReader access$600(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.frameReader;
    }

    static /* synthetic */ Http2SettingsReceivedConsumer access$700(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.settingsReceivedConsumer;
    }

    static /* synthetic */ boolean access$800(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.autoAckPing;
    }

    static /* synthetic */ Http2PromisedRequestVerifier access$900(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.requestVerifier;
    }

    static /* synthetic */ InternalLogger access$1000() {
        return logger;
    }

    static /* synthetic */ Http2FrameListener access$1100(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.internalFrameListener;
    }

    static /* synthetic */ Http2FrameListener access$1102(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder, Http2FrameListener http2FrameListener) {
        defaultHttp2ConnectionDecoder.internalFrameListener = http2FrameListener;
        return defaultHttp2ConnectionDecoder.internalFrameListener;
    }
}

