/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$Endpoint;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameReader$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersDecoder$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream$State;

final class DefaultHttp2ConnectionDecoder$FrameReadListener
implements Http2FrameListener {
    final /* synthetic */ DefaultHttp2ConnectionDecoder this$0;

    private DefaultHttp2ConnectionDecoder$FrameReadListener(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        this.this$0 = defaultHttp2ConnectionDecoder;
    }

    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3) {
        boolean bl4;
        Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).stream(n4);
        Http2LocalFlowController http2LocalFlowController = this.this$0.flowController();
        int n8 = byteBuf.readableBytes() + n7;
        try {
            bl4 = this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n4, http2Stream, "DATA");
        }
        catch (Http2Exception http2Exception) {
            http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n7, bl3);
            http2LocalFlowController.consumeBytes(http2Stream, n8);
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Unhandled error on data stream id %d", n4);
        }
        if (bl4) {
            http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n7, bl3);
            http2LocalFlowController.consumeBytes(http2Stream, n8);
            this.verifyStreamMayHaveExisted(n4);
            return n8;
        }
        Http2Exception http2Exception = null;
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_LOCAL: {
                break;
            }
            case HALF_CLOSED_REMOTE: 
            case CLOSED: {
                http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                break;
            }
            default: {
                http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
            }
        }
        int n10 = DefaultHttp2ConnectionDecoder.access$200(this.this$0, http2Stream);
        try {
            http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n7, bl3);
            n10 = DefaultHttp2ConnectionDecoder.access$200(this.this$0, http2Stream);
            if (http2Exception != null) {
                throw http2Exception;
            }
            int n11 = n8 = DefaultHttp2ConnectionDecoder.access$300(this.this$0).onDataRead(channelHandlerContext, n4, byteBuf, n7, bl3);
            return n11;
        }
        catch (Http2Exception http2Exception2) {
            int n12 = n10 - DefaultHttp2ConnectionDecoder.access$200(this.this$0, http2Stream);
            n8 -= n12;
            throw http2Exception2;
        }
        catch (RuntimeException runtimeException) {
            int n13 = n10 - DefaultHttp2ConnectionDecoder.access$200(this.this$0, http2Stream);
            n8 -= n13;
            throw runtimeException;
        }
        finally {
            http2LocalFlowController.consumeBytes(http2Stream, n8);
            if (bl3) {
                DefaultHttp2ConnectionDecoder.access$400(this.this$0).closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
            }
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3) {
        this.onHeadersRead(channelHandlerContext, n4, http2Headers, 0, (short)16, false, n7, bl3);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4) {
        boolean bl5;
        Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).stream(n4);
        boolean bl6 = false;
        if (http2Stream == null && !DefaultHttp2ConnectionDecoder.access$100(this.this$0).streamMayHaveExisted(n4)) {
            http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).remote().createStream(n4, bl4);
            boolean bl8 = bl6 = http2Stream.state() == Http2Stream$State.HALF_CLOSED_REMOTE;
        }
        if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n4, http2Stream, "HEADERS")) {
            return;
        }
        boolean bl9 = bl5 = !DefaultHttp2ConnectionDecoder.access$100(this.this$0).isServer() && HttpStatusClass.valueOf(http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((bl5 || !bl4) && http2Stream.isHeadersReceived() || http2Stream.isTrailersReceived()) {
            throw Http2Exception.streamError(n4, Http2Error.PROTOCOL_ERROR, "Stream %d received too many headers EOS: %s state: %s", new Object[]{n4, bl4, http2Stream.state()});
        }
        switch (http2Stream.state()) {
            case RESERVED_REMOTE: {
                http2Stream.open(bl4);
                break;
            }
            case OPEN: 
            case HALF_CLOSED_LOCAL: {
                break;
            }
            case HALF_CLOSED_REMOTE: {
                if (bl6) break;
                throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
            }
            case CLOSED: {
                throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
            }
            default: {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
            }
        }
        http2Stream.headersReceived(bl5);
        DefaultHttp2ConnectionDecoder.access$500(this.this$0).flowController().updateDependencyTree(n4, n7, s11, bl3);
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onHeadersRead(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4);
        if (bl4) {
            DefaultHttp2ConnectionDecoder.access$400(this.this$0).closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
        }
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n4, int n7, short s11, boolean bl3) {
        DefaultHttp2ConnectionDecoder.access$500(this.this$0).flowController().updateDependencyTree(n4, n7, s11, bl3);
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onPriorityRead(channelHandlerContext, n4, n7, s11, bl3);
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n4, long l2) {
        Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).stream(n4);
        if (http2Stream == null) {
            this.verifyStreamMayHaveExisted(n4);
            return;
        }
        switch (http2Stream.state()) {
            case IDLE: {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "RST_STREAM received for IDLE stream %d", n4);
            }
            case CLOSED: {
                return;
            }
        }
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onRstStreamRead(channelHandlerContext, n4, l2);
        DefaultHttp2ConnectionDecoder.access$400(this.this$0).closeStream(http2Stream, channelHandlerContext.newSucceededFuture());
    }

    @Override
    public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) {
        Http2Settings http2Settings = DefaultHttp2ConnectionDecoder.access$500(this.this$0).pollSentSettings();
        if (http2Settings != null) {
            this.applyLocalSettings(http2Settings);
        }
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onSettingsAckRead(channelHandlerContext);
    }

    private void applyLocalSettings(Http2Settings http2Settings) {
        Integer n4;
        Integer n7;
        Long l2;
        Long l10;
        Long l11;
        Boolean bl3 = http2Settings.pushEnabled();
        Http2FrameReader$Configuration http2FrameReader$Configuration = DefaultHttp2ConnectionDecoder.access$600(this.this$0).configuration();
        Http2HeadersDecoder$Configuration http2HeadersDecoder$Configuration = http2FrameReader$Configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = http2FrameReader$Configuration.frameSizePolicy();
        if (bl3 != null) {
            if (DefaultHttp2ConnectionDecoder.access$100(this.this$0).isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
            DefaultHttp2ConnectionDecoder.access$100(this.this$0).local().allowPushTo(bl3);
        }
        if ((l11 = http2Settings.maxConcurrentStreams()) != null) {
            DefaultHttp2ConnectionDecoder.access$100(this.this$0).remote().maxActiveStreams((int)Math.min(l11, Integer.MAX_VALUE));
        }
        if ((l10 = http2Settings.headerTableSize()) != null) {
            http2HeadersDecoder$Configuration.maxHeaderTableSize(l10);
        }
        if ((l2 = http2Settings.maxHeaderListSize()) != null) {
            http2HeadersDecoder$Configuration.maxHeaderListSize(l2, this.this$0.calculateMaxHeaderListSizeGoAway(l2));
        }
        if ((n7 = http2Settings.maxFrameSize()) != null) {
            http2FrameSizePolicy.maxFrameSize(n7);
        }
        if ((n4 = http2Settings.initialWindowSize()) != null) {
            this.this$0.flowController().initialWindowSize(n4);
        }
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (DefaultHttp2ConnectionDecoder.access$700(this.this$0) == null) {
            DefaultHttp2ConnectionDecoder.access$500(this.this$0).writeSettingsAck(channelHandlerContext, channelHandlerContext.newPromise());
            DefaultHttp2ConnectionDecoder.access$500(this.this$0).remoteSettings(http2Settings);
        } else {
            DefaultHttp2ConnectionDecoder.access$700(this.this$0).consumeReceivedSettings(http2Settings);
        }
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onSettingsRead(channelHandlerContext, http2Settings);
    }

    @Override
    public void onPingRead(ChannelHandlerContext channelHandlerContext, long l2) {
        if (DefaultHttp2ConnectionDecoder.access$800(this.this$0)) {
            DefaultHttp2ConnectionDecoder.access$500(this.this$0).writePing(channelHandlerContext, true, l2, channelHandlerContext.newPromise());
        }
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onPingRead(channelHandlerContext, l2);
    }

    @Override
    public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l2) {
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onPingAckRead(channelHandlerContext, l2);
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n4, int n7, Http2Headers http2Headers, int n8) {
        if (this.this$0.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A client cannot push.", new Object[0]);
        }
        Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).stream(n4);
        if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n4, http2Stream, "PUSH_PROMISE")) {
            return;
        }
        if (http2Stream == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n4);
        }
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_LOCAL: {
                break;
            }
            default: {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state for receiving push promise: %s", new Object[]{http2Stream.id(), http2Stream.state()});
            }
        }
        if (!DefaultHttp2ConnectionDecoder.access$900(this.this$0).isAuthoritative(channelHandlerContext, http2Headers)) {
            throw Http2Exception.streamError(n7, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not authoritative", n4, n7);
        }
        if (!DefaultHttp2ConnectionDecoder.access$900(this.this$0).isCacheable(http2Headers)) {
            throw Http2Exception.streamError(n7, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be cacheable", n4, n7);
        }
        if (!DefaultHttp2ConnectionDecoder.access$900(this.this$0).isSafe(http2Headers)) {
            throw Http2Exception.streamError(n7, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be safe", n4, n7);
        }
        DefaultHttp2ConnectionDecoder.access$100(this.this$0).remote().reservePushStream(n7, http2Stream);
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onPushPromiseRead(channelHandlerContext, n4, n7, http2Headers, n8);
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf) {
        this.this$0.onGoAwayRead0(channelHandlerContext, n4, l2, byteBuf);
    }

    @Override
    public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n4, int n7) {
        Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.access$100(this.this$0).stream(n4);
        if (http2Stream == null || http2Stream.state() == Http2Stream$State.CLOSED || this.streamCreatedAfterGoAwaySent(n4)) {
            this.verifyStreamMayHaveExisted(n4);
            return;
        }
        DefaultHttp2ConnectionDecoder.access$500(this.this$0).flowController().incrementWindowSize(http2Stream, n7);
        DefaultHttp2ConnectionDecoder.access$300(this.this$0).onWindowUpdateRead(channelHandlerContext, n4, n7);
    }

    @Override
    public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n4, Http2Flags http2Flags, ByteBuf byteBuf) {
        this.this$0.onUnknownFrame0(channelHandlerContext, by2, n4, http2Flags, byteBuf);
    }

    private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext channelHandlerContext, int n4, Http2Stream http2Stream, String string) {
        if (http2Stream == null) {
            if (this.streamCreatedAfterGoAwaySent(n4)) {
                DefaultHttp2ConnectionDecoder.access$1000().info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", channelHandlerContext.channel(), string, n4);
                return true;
            }
            throw Http2Exception.streamError(n4, Http2Error.STREAM_CLOSED, "Received %s frame for an unknown stream %d", string, n4);
        }
        if (http2Stream.isResetSent() || this.streamCreatedAfterGoAwaySent(n4)) {
            if (DefaultHttp2ConnectionDecoder.access$1000().isInfoEnabled()) {
                DefaultHttp2ConnectionDecoder.access$1000().info("{} ignoring {} frame for stream {}", channelHandlerContext.channel(), string, http2Stream.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + DefaultHttp2ConnectionDecoder.access$100(this.this$0).remote().lastStreamKnownByPeer());
            }
            return true;
        }
        return false;
    }

    private boolean streamCreatedAfterGoAwaySent(int n4) {
        Http2Connection$Endpoint<Http2RemoteFlowController> http2Connection$Endpoint = DefaultHttp2ConnectionDecoder.access$100(this.this$0).remote();
        return DefaultHttp2ConnectionDecoder.access$100(this.this$0).goAwaySent() && http2Connection$Endpoint.isValidStreamId(n4) && n4 > http2Connection$Endpoint.lastStreamKnownByPeer();
    }

    private void verifyStreamMayHaveExisted(int n4) {
        if (!DefaultHttp2ConnectionDecoder.access$100(this.this$0).streamMayHaveExisted(n4)) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n4);
        }
    }

    /* synthetic */ DefaultHttp2ConnectionDecoder$FrameReadListener(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder, DefaultHttp2ConnectionDecoder$1 defaultHttp2ConnectionDecoder$1) {
        this(defaultHttp2ConnectionDecoder);
    }
}

