/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.util.concurrent.PromiseCombiner;

public class CompressorHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int DEFAULT_WINDOW_BITS = 15;
    public static final int DEFAULT_MEM_LEVEL = 8;
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private final Http2Connection.PropertyKey propertyKey;

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder http2ConnectionEncoder) {
        this(http2ConnectionEncoder, 6, 15, 8);
    }

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder http2ConnectionEncoder, int n4, int n7, int n8) {
        super(http2ConnectionEncoder);
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        if (n7 < 9 || n7 > 15) {
            throw new IllegalArgumentException("windowBits: " + n7 + " (expected: 9-15)");
        }
        if (n8 < 1 || n8 > 9) {
            throw new IllegalArgumentException("memLevel: " + n8 + " (expected: 1-9)");
        }
        this.compressionLevel = n4;
        this.windowBits = n7;
        this.memLevel = n8;
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new CompressorHttp2ConnectionEncoder$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3, ChannelPromise channelPromise) {
        EmbeddedChannel embeddedChannel;
        Http2Stream http2Stream = this.connection().stream(n4);
        EmbeddedChannel embeddedChannel2 = embeddedChannel = http2Stream == null ? null : (EmbeddedChannel)http2Stream.getProperty(this.propertyKey);
        if (embeddedChannel == null) {
            return super.writeData(channelHandlerContext, n4, byteBuf, n7, bl3, channelPromise);
        }
        try {
            embeddedChannel.writeOutbound(byteBuf);
            ByteBuf byteBuf2 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
            if (byteBuf2 == null) {
                if (bl3) {
                    if (embeddedChannel.finish()) {
                        byteBuf2 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
                    }
                    ChannelFuture channelFuture = super.writeData(channelHandlerContext, n4, byteBuf2 == null ? Unpooled.EMPTY_BUFFER : byteBuf2, n7, true, channelPromise);
                    return channelFuture;
                }
                channelPromise.setSuccess();
                ChannelPromise channelPromise2 = channelPromise;
                return channelPromise2;
            }
            PromiseCombiner promiseCombiner = new PromiseCombiner(channelHandlerContext.executor());
            while (true) {
                ByteBuf byteBuf3;
                boolean bl4;
                boolean bl5 = bl4 = (byteBuf3 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel)) == null && bl3;
                if (bl4 && embeddedChannel.finish()) {
                    byteBuf3 = CompressorHttp2ConnectionEncoder.nextReadableBuf(embeddedChannel);
                    bl4 = byteBuf3 == null;
                }
                ChannelPromise channelPromise3 = channelHandlerContext.newPromise();
                promiseCombiner.add(channelPromise3);
                super.writeData(channelHandlerContext, n4, byteBuf2, n7, bl4, channelPromise3);
                if (byteBuf3 == null) break;
                n7 = 0;
                byteBuf2 = byteBuf3;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        finally {
            if (bl3) {
                this.cleanup(http2Stream, embeddedChannel);
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, ChannelPromise channelPromise) {
        try {
            EmbeddedChannel embeddedChannel = this.newCompressor(channelHandlerContext, http2Headers, bl3);
            ChannelFuture channelFuture = super.writeHeaders(channelHandlerContext, n4, http2Headers, n7, bl3, channelPromise);
            this.bindCompressorToStream(embeddedChannel, n4);
            return channelFuture;
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4, ChannelPromise channelPromise) {
        try {
            EmbeddedChannel embeddedChannel = this.newCompressor(channelHandlerContext, http2Headers, bl4);
            ChannelFuture channelFuture = super.writeHeaders(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4, channelPromise);
            this.bindCompressorToStream(embeddedChannel, n4);
            return channelFuture;
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    protected EmbeddedChannel newContentCompressor(ChannelHandlerContext channelHandlerContext, CharSequence charSequence) {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(charSequence)) {
            return this.newCompressionChannel(channelHandlerContext, ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(charSequence) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(charSequence)) {
            return this.newCompressionChannel(channelHandlerContext, ZlibWrapper.ZLIB);
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence charSequence) {
        return charSequence;
    }

    private EmbeddedChannel newCompressionChannel(ChannelHandlerContext channelHandlerContext, ZlibWrapper zlibWrapper) {
        return new EmbeddedChannel(channelHandlerContext.channel().id(), channelHandlerContext.channel().metadata().hasDisconnect(), channelHandlerContext.channel().config(), ZlibCodecFactory.newZlibEncoder(zlibWrapper, this.compressionLevel, this.windowBits, this.memLevel));
    }

    private EmbeddedChannel newCompressor(ChannelHandlerContext channelHandlerContext, Http2Headers http2Headers, boolean bl3) {
        EmbeddedChannel embeddedChannel;
        if (bl3) {
            return null;
        }
        CharSequence charSequence = (CharSequence)http2Headers.get(HttpHeaderNames.CONTENT_ENCODING);
        if (charSequence == null) {
            charSequence = HttpHeaderValues.IDENTITY;
        }
        if ((embeddedChannel = this.newContentCompressor(channelHandlerContext, charSequence)) != null) {
            CharSequence charSequence2 = this.getTargetContentEncoding(charSequence);
            if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(charSequence2)) {
                http2Headers.remove(HttpHeaderNames.CONTENT_ENCODING);
            } else {
                http2Headers.set(HttpHeaderNames.CONTENT_ENCODING, charSequence2);
            }
            http2Headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        return embeddedChannel;
    }

    private void bindCompressorToStream(EmbeddedChannel embeddedChannel, int n4) {
        Http2Stream http2Stream;
        if (embeddedChannel != null && (http2Stream = this.connection().stream(n4)) != null) {
            http2Stream.setProperty(this.propertyKey, embeddedChannel);
        }
    }

    void cleanup(Http2Stream http2Stream, EmbeddedChannel embeddedChannel) {
        if (embeddedChannel.finish()) {
            ByteBuf byteBuf;
            while ((byteBuf = (ByteBuf)embeddedChannel.readOutbound()) != null) {
                byteBuf.release();
            }
        }
        http2Stream.removeProperty(this.propertyKey);
    }

    private static ByteBuf nextReadableBuf(EmbeddedChannel embeddedChannel) {
        ByteBuf byteBuf;
        while (true) {
            if ((byteBuf = (ByteBuf)embeddedChannel.readOutbound()) == null) {
                return null;
            }
            if (byteBuf.isReadable()) break;
            byteBuf.release();
        }
        return byteBuf;
    }

    static /* synthetic */ Http2Connection.PropertyKey access$000(CompressorHttp2ConnectionEncoder compressorHttp2ConnectionEncoder) {
        return compressorHttp2ConnectionEncoder.propertyKey;
    }
}

