/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.Channel$Unsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelId;
import io.grpc.netty.shaded.io.netty.channel.ChannelMetadata;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelProgressivePromise;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator$Handle;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$3;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2ChannelUnsafe;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2StreamChannelConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$ReadStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannelId;
import io.grpc.netty.shaded.io.netty.util.DefaultAttributeMap;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

abstract class AbstractHttp2StreamChannel
extends DefaultAttributeMap
implements Http2StreamChannel {
    static final Http2FrameStreamVisitor WRITABLE_VISITOR = new AbstractHttp2StreamChannel$1();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractHttp2StreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final int MIN_HTTP2_FRAME_SIZE = 9;
    private static final AtomicLongFieldUpdater<AbstractHttp2StreamChannel> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "totalPendingSize");
    private static final AtomicIntegerFieldUpdater<AbstractHttp2StreamChannel> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "unwritable");
    private final AbstractHttp2StreamChannel$Http2StreamChannelConfig config = new AbstractHttp2StreamChannel$Http2StreamChannelConfig(this, this);
    private final AbstractHttp2StreamChannel$Http2ChannelUnsafe unsafe = new AbstractHttp2StreamChannel$Http2ChannelUnsafe(this, null);
    private final ChannelId channelId;
    private final ChannelPipeline pipeline;
    private final Http2FrameCodec$DefaultHttp2FrameStream stream;
    private final ChannelPromise closePromise;
    private volatile boolean registered;
    private volatile long totalPendingSize;
    private volatile int unwritable;
    private Runnable fireChannelWritabilityChangedTask;
    private boolean outboundClosed;
    private int flowControlledBytes;
    private AbstractHttp2StreamChannel$ReadStatus readStatus = AbstractHttp2StreamChannel$ReadStatus.IDLE;
    private Queue<Object> inboundBuffer;
    private boolean firstFrameWritten;
    private boolean readCompletePending;

    AbstractHttp2StreamChannel(Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream, int n4, ChannelHandler channelHandler) {
        this.stream = http2FrameCodec$DefaultHttp2FrameStream;
        http2FrameCodec$DefaultHttp2FrameStream.attachment = this;
        this.pipeline = new AbstractHttp2StreamChannel$2(this, this);
        this.closePromise = this.pipeline.newPromise();
        this.channelId = new Http2StreamChannelId(this.parent().id(), n4);
        if (channelHandler != null) {
            this.pipeline.addLast(channelHandler);
        }
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl3) {
        if (l2 == 0L) {
            return;
        }
        long l10 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l10 > (long)this.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl3);
        }
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl3) {
        if (l2 == 0L) {
            return;
        }
        long l10 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (l10 < (long)this.config().getWriteBufferLowWaterMark() && this.parent().isWritable()) {
            this.setWritable(bl3);
        }
    }

    final void trySetWritable() {
        if (this.totalPendingSize < (long)this.config().getWriteBufferLowWaterMark()) {
            this.setWritable(false);
        }
    }

    private void setWritable(boolean bl3) {
        block1: {
            int n4;
            int n7;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n7 = this.unwritable, n4 = n7 & 0xFFFFFFFE)) {
            }
            if (n7 == 0 || n4 != 0) break block1;
            this.fireChannelWritabilityChanged(bl3);
        }
    }

    private void setUnwritable(boolean bl3) {
        block1: {
            int n4;
            int n7;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n7 = this.unwritable, n4 = n7 | 1)) {
            }
            if (n7 != 0 || n4 == 0) break block1;
            this.fireChannelWritabilityChanged(bl3);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl3) {
        ChannelPipeline channelPipeline = this.pipeline();
        if (bl3) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new AbstractHttp2StreamChannel$3(this, channelPipeline);
            }
            this.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    void closeOutbound() {
        this.outboundClosed = true;
    }

    void streamClosed() {
        this.unsafe.readEOS();
        this.unsafe.doBeginRead();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.closePromise.isDone();
    }

    @Override
    public boolean isActive() {
        return this.isOpen();
    }

    @Override
    public boolean isWritable() {
        return this.unwritable == 0;
    }

    @Override
    public ChannelId id() {
        return this.channelId;
    }

    @Override
    public EventLoop eventLoop() {
        return this.parent().eventLoop();
    }

    @Override
    public Channel parent() {
        return this.parentContext().channel();
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public SocketAddress localAddress() {
        return this.parent().localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.parent().remoteAddress();
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closePromise;
    }

    @Override
    public long bytesBeforeUnwritable() {
        long l2 = (long)this.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l2 > 0L) {
            return this.isWritable() ? l2 : 0L;
        }
        return 0L;
    }

    @Override
    public long bytesBeforeWritable() {
        long l2 = this.totalPendingSize - (long)this.config().getWriteBufferLowWaterMark();
        if (l2 > 0L) {
            return this.isWritable() ? 0L : l2;
        }
        return 0L;
    }

    @Override
    public Channel$Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public Channel read() {
        this.pipeline().read();
        return this;
    }

    @Override
    public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline().bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline().connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline().connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline().disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline().close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline().deregister();
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline().disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline().close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline().deregister(channelPromise);
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.pipeline().write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline().write(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline().writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline().writeAndFlush(object);
    }

    @Override
    public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline().newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline().newFailedFuture(throwable);
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        return this.parent().toString() + "(H2 - " + this.stream + ')';
    }

    void fireChildRead(Http2Frame http2Frame) {
        assert (this.eventLoop().inEventLoop());
        if (!this.isActive()) {
            ReferenceCountUtil.release(http2Frame);
        } else if (this.readStatus != AbstractHttp2StreamChannel$ReadStatus.IDLE) {
            assert (this.inboundBuffer == null || this.inboundBuffer.isEmpty());
            RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe.recvBufAllocHandle();
            this.flowControlledBytes += this.unsafe.doRead0(http2Frame, recvByteBufAllocator$Handle);
            if (recvByteBufAllocator$Handle.continueReading()) {
                if (!this.readCompletePending) {
                    this.readCompletePending = true;
                    this.addChannelToReadCompletePendingQueue();
                }
            } else {
                this.unsafe.notifyReadComplete(recvByteBufAllocator$Handle, true);
            }
        } else {
            if (this.inboundBuffer == null) {
                this.inboundBuffer = new ArrayDeque<Object>(4);
            }
            this.inboundBuffer.add(http2Frame);
        }
    }

    void fireChildReadComplete() {
        assert (this.eventLoop().inEventLoop());
        assert (this.readStatus != AbstractHttp2StreamChannel$ReadStatus.IDLE || !this.readCompletePending);
        this.unsafe.notifyReadComplete(this.unsafe.recvBufAllocHandle(), false);
    }

    protected void flush0(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    protected ChannelFuture write0(ChannelHandlerContext channelHandlerContext, Object object) {
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        channelHandlerContext.write(object, channelPromise);
        return channelPromise;
    }

    protected abstract boolean isParentReadInProgress();

    protected abstract void addChannelToReadCompletePendingQueue();

    protected abstract ChannelHandlerContext parentContext();

    static /* synthetic */ void access$100(AbstractHttp2StreamChannel abstractHttp2StreamChannel, long l2, boolean bl3) {
        abstractHttp2StreamChannel.incrementPendingOutboundBytes(l2, bl3);
    }

    static /* synthetic */ void access$200(AbstractHttp2StreamChannel abstractHttp2StreamChannel, long l2, boolean bl3) {
        abstractHttp2StreamChannel.decrementPendingOutboundBytes(l2, bl3);
    }

    static /* synthetic */ boolean access$300(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.registered;
    }

    static /* synthetic */ boolean access$302(AbstractHttp2StreamChannel abstractHttp2StreamChannel, boolean bl3) {
        abstractHttp2StreamChannel.registered = bl3;
        return abstractHttp2StreamChannel.registered;
    }

    static /* synthetic */ ChannelPromise access$400(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.closePromise;
    }

    static /* synthetic */ boolean access$502(AbstractHttp2StreamChannel abstractHttp2StreamChannel, boolean bl3) {
        abstractHttp2StreamChannel.readCompletePending = bl3;
        return abstractHttp2StreamChannel.readCompletePending;
    }

    static /* synthetic */ Http2FrameCodec$DefaultHttp2FrameStream access$600(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.stream;
    }

    static /* synthetic */ Queue access$700(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.inboundBuffer;
    }

    static /* synthetic */ Queue access$702(AbstractHttp2StreamChannel abstractHttp2StreamChannel, Queue queue) {
        abstractHttp2StreamChannel.inboundBuffer = queue;
        return abstractHttp2StreamChannel.inboundBuffer;
    }

    static /* synthetic */ boolean access$802(AbstractHttp2StreamChannel abstractHttp2StreamChannel, boolean bl3) {
        abstractHttp2StreamChannel.outboundClosed = bl3;
        return abstractHttp2StreamChannel.outboundClosed;
    }

    static /* synthetic */ ChannelPipeline access$900(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.pipeline;
    }

    static /* synthetic */ InternalLogger access$1100() {
        return logger;
    }

    static /* synthetic */ AbstractHttp2StreamChannel$ReadStatus access$1200(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.readStatus;
    }

    static /* synthetic */ AbstractHttp2StreamChannel$ReadStatus access$1202(AbstractHttp2StreamChannel abstractHttp2StreamChannel, AbstractHttp2StreamChannel$ReadStatus abstractHttp2StreamChannel$ReadStatus) {
        abstractHttp2StreamChannel.readStatus = abstractHttp2StreamChannel$ReadStatus;
        return abstractHttp2StreamChannel.readStatus;
    }

    static /* synthetic */ AbstractHttp2StreamChannel$Http2ChannelUnsafe access$1300(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.unsafe;
    }

    static /* synthetic */ int access$1400(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.flowControlledBytes;
    }

    static /* synthetic */ int access$1402(AbstractHttp2StreamChannel abstractHttp2StreamChannel, int n4) {
        abstractHttp2StreamChannel.flowControlledBytes = n4;
        return abstractHttp2StreamChannel.flowControlledBytes;
    }

    static /* synthetic */ boolean access$500(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.readCompletePending;
    }

    static /* synthetic */ boolean access$800(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.outboundClosed;
    }

    static /* synthetic */ boolean access$1500(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.firstFrameWritten;
    }

    static /* synthetic */ boolean access$1502(AbstractHttp2StreamChannel abstractHttp2StreamChannel, boolean bl3) {
        abstractHttp2StreamChannel.firstFrameWritten = bl3;
        return abstractHttp2StreamChannel.firstFrameWritten;
    }

    static /* synthetic */ AbstractHttp2StreamChannel$Http2StreamChannelConfig access$1900(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        return abstractHttp2StreamChannel.config;
    }
}

