/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.Channel$Unsafe;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.RecvByteBufAllocator$Handle;
import io.grpc.netty.shaded.io.netty.channel.VoidChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$FlowControlledFrameSizeEstimator;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2ChannelUnsafe$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2ChannelUnsafe$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2ChannelUnsafe$3;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$Http2ChannelUnsafe$4;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel$ReadStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.RejectedExecutionException;

final class AbstractHttp2StreamChannel$Http2ChannelUnsafe
implements Channel$Unsafe {
    private final VoidChannelPromise unsafeVoidPromise;
    private RecvByteBufAllocator$Handle recvHandle;
    private boolean writeDoneAndNoFlush;
    private boolean closeInitiated;
    private boolean readEOS;
    final /* synthetic */ AbstractHttp2StreamChannel this$0;

    private AbstractHttp2StreamChannel$Http2ChannelUnsafe(AbstractHttp2StreamChannel abstractHttp2StreamChannel) {
        this.this$0 = abstractHttp2StreamChannel;
        this.unsafeVoidPromise = new VoidChannelPromise(this.this$0, false);
    }

    @Override
    public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        channelPromise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public RecvByteBufAllocator$Handle recvBufAllocHandle() {
        if (this.recvHandle == null) {
            this.recvHandle = this.this$0.config().getRecvByteBufAllocator().newHandle();
            this.recvHandle.reset(this.this$0.config());
        }
        return this.recvHandle;
    }

    @Override
    public SocketAddress localAddress() {
        return this.this$0.parent().unsafe().localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.this$0.parent().unsafe().remoteAddress();
    }

    @Override
    public void register(EventLoop eventLoop, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (AbstractHttp2StreamChannel.access$300(this.this$0)) {
            channelPromise.setFailure(new UnsupportedOperationException("Re-register is not supported"));
            return;
        }
        AbstractHttp2StreamChannel.access$302(this.this$0, true);
        channelPromise.setSuccess();
        this.this$0.pipeline().fireChannelRegistered();
        if (this.this$0.isActive()) {
            this.this$0.pipeline().fireChannelActive();
        }
    }

    @Override
    public void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        channelPromise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void disconnect(ChannelPromise channelPromise) {
        this.close(channelPromise);
    }

    @Override
    public void close(ChannelPromise channelPromise) {
        Object object;
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (this.closeInitiated) {
            if (AbstractHttp2StreamChannel.access$400(this.this$0).isDone()) {
                channelPromise.setSuccess();
            } else if (!(channelPromise instanceof VoidChannelPromise)) {
                AbstractHttp2StreamChannel.access$400(this.this$0).addListener(new AbstractHttp2StreamChannel$Http2ChannelUnsafe$1(this, channelPromise));
            }
            return;
        }
        this.closeInitiated = true;
        AbstractHttp2StreamChannel.access$502(this.this$0, false);
        boolean bl3 = this.this$0.isActive();
        this.updateLocalWindowIfNeeded();
        if (this.this$0.parent().isActive() && !this.readEOS && Http2CodecUtil.isStreamIdValid(AbstractHttp2StreamChannel.access$600(this.this$0).id())) {
            object = new DefaultHttp2ResetFrame(Http2Error.CANCEL).stream(this.this$0.stream());
            this.write(object, this.this$0.unsafe().voidPromise());
            this.flush();
        }
        if (AbstractHttp2StreamChannel.access$700(this.this$0) != null) {
            while ((object = AbstractHttp2StreamChannel.access$700(this.this$0).poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            AbstractHttp2StreamChannel.access$702(this.this$0, null);
        }
        AbstractHttp2StreamChannel.access$802(this.this$0, true);
        AbstractHttp2StreamChannel.access$400(this.this$0).setSuccess();
        channelPromise.setSuccess();
        this.fireChannelInactiveAndDeregister(this.voidPromise(), bl3);
    }

    @Override
    public void closeForcibly() {
        this.close(this.this$0.unsafe().voidPromise());
    }

    @Override
    public void deregister(ChannelPromise channelPromise) {
        this.fireChannelInactiveAndDeregister(channelPromise, false);
    }

    private void fireChannelInactiveAndDeregister(ChannelPromise channelPromise, boolean bl3) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (!AbstractHttp2StreamChannel.access$300(this.this$0)) {
            channelPromise.setSuccess();
            return;
        }
        this.invokeLater(new AbstractHttp2StreamChannel$Http2ChannelUnsafe$2(this, bl3, channelPromise));
    }

    private void safeSetSuccess(ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
            AbstractHttp2StreamChannel.access$1100().warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
        }
    }

    private void invokeLater(Runnable runnable) {
        try {
            this.this$0.eventLoop().execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AbstractHttp2StreamChannel.access$1100().warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
        }
    }

    @Override
    public void beginRead() {
        if (!this.this$0.isActive()) {
            return;
        }
        switch (AbstractHttp2StreamChannel.access$1200(this.this$0)) {
            case IDLE: {
                AbstractHttp2StreamChannel.access$1202(this.this$0, AbstractHttp2StreamChannel$ReadStatus.IN_PROGRESS);
                this.doBeginRead();
                break;
            }
            case IN_PROGRESS: {
                AbstractHttp2StreamChannel.access$1202(this.this$0, AbstractHttp2StreamChannel$ReadStatus.REQUESTED);
                break;
            }
        }
    }

    private Object pollQueuedMessage() {
        return AbstractHttp2StreamChannel.access$700(this.this$0) == null ? null : AbstractHttp2StreamChannel.access$700(this.this$0).poll();
    }

    void doBeginRead() {
        while (AbstractHttp2StreamChannel.access$1200(this.this$0) != AbstractHttp2StreamChannel$ReadStatus.IDLE) {
            Object object = this.pollQueuedMessage();
            if (object == null) {
                if (!this.readEOS) break;
                AbstractHttp2StreamChannel.access$1300(this.this$0).closeForcibly();
                break;
            }
            RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.recvBufAllocHandle();
            recvByteBufAllocator$Handle.reset(this.this$0.config());
            boolean bl3 = false;
            do {
                AbstractHttp2StreamChannel.access$1402(this.this$0, AbstractHttp2StreamChannel.access$1400(this.this$0) + this.doRead0((Http2Frame)object, recvByteBufAllocator$Handle));
            } while ((this.readEOS || (bl3 = recvByteBufAllocator$Handle.continueReading())) && (object = this.pollQueuedMessage()) != null);
            if (bl3 && this.this$0.isParentReadInProgress() && !this.readEOS) {
                if (AbstractHttp2StreamChannel.access$500(this.this$0)) continue;
                AbstractHttp2StreamChannel.access$502(this.this$0, true);
                this.this$0.addChannelToReadCompletePendingQueue();
                continue;
            }
            this.notifyReadComplete(recvByteBufAllocator$Handle, true);
        }
    }

    void readEOS() {
        this.readEOS = true;
    }

    private void updateLocalWindowIfNeeded() {
        if (AbstractHttp2StreamChannel.access$1400(this.this$0) != 0) {
            int n4 = AbstractHttp2StreamChannel.access$1400(this.this$0);
            AbstractHttp2StreamChannel.access$1402(this.this$0, 0);
            this.this$0.write0(this.this$0.parentContext(), new DefaultHttp2WindowUpdateFrame(n4).stream(AbstractHttp2StreamChannel.access$600(this.this$0)));
            this.writeDoneAndNoFlush = true;
        }
    }

    void notifyReadComplete(RecvByteBufAllocator$Handle recvByteBufAllocator$Handle, boolean bl3) {
        if (!AbstractHttp2StreamChannel.access$500(this.this$0) && !bl3) {
            return;
        }
        AbstractHttp2StreamChannel.access$502(this.this$0, false);
        if (AbstractHttp2StreamChannel.access$1200(this.this$0) == AbstractHttp2StreamChannel$ReadStatus.REQUESTED) {
            AbstractHttp2StreamChannel.access$1202(this.this$0, AbstractHttp2StreamChannel$ReadStatus.IN_PROGRESS);
        } else {
            AbstractHttp2StreamChannel.access$1202(this.this$0, AbstractHttp2StreamChannel$ReadStatus.IDLE);
        }
        this.updateLocalWindowIfNeeded();
        recvByteBufAllocator$Handle.readComplete();
        this.this$0.pipeline().fireChannelReadComplete();
        this.flush();
        if (this.readEOS) {
            AbstractHttp2StreamChannel.access$1300(this.this$0).closeForcibly();
        }
    }

    int doRead0(Http2Frame http2Frame, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        this.this$0.pipeline().fireChannelRead(http2Frame);
        recvByteBufAllocator$Handle.incMessagesRead(1);
        if (http2Frame instanceof Http2DataFrame) {
            int n4 = ((Http2DataFrame)http2Frame).initialFlowControlledBytes();
            recvByteBufAllocator$Handle.attemptedBytesRead(n4);
            recvByteBufAllocator$Handle.lastBytesRead(n4);
            return n4;
        }
        recvByteBufAllocator$Handle.attemptedBytesRead(9);
        recvByteBufAllocator$Handle.lastBytesRead(9);
        return 0;
    }

    @Override
    public void write(Object object, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            ReferenceCountUtil.release(object);
            return;
        }
        if (!this.this$0.isActive() || AbstractHttp2StreamChannel.access$800(this.this$0) && (object instanceof Http2HeadersFrame || object instanceof Http2DataFrame)) {
            ReferenceCountUtil.release(object);
            channelPromise.setFailure(new ClosedChannelException());
            return;
        }
        try {
            Object object2;
            if (object instanceof Http2StreamFrame) {
                object2 = this.validateStreamFrame((Http2StreamFrame)object).stream(this.this$0.stream());
                if (!AbstractHttp2StreamChannel.access$1500(this.this$0) && !Http2CodecUtil.isStreamIdValid(this.this$0.stream().id())) {
                    if (!(object2 instanceof Http2HeadersFrame)) {
                        ReferenceCountUtil.release(object2);
                        channelPromise.setFailure(new IllegalArgumentException("The first frame must be a headers frame. Was: " + object2.name()));
                        return;
                    }
                    AbstractHttp2StreamChannel.access$1502(this.this$0, true);
                    ChannelFuture channelFuture = this.this$0.write0(this.this$0.parentContext(), object2);
                    if (channelFuture.isDone()) {
                        this.firstWriteComplete(channelFuture, channelPromise);
                    } else {
                        long l2 = AbstractHttp2StreamChannel$FlowControlledFrameSizeEstimator.access$1600().size(object);
                        AbstractHttp2StreamChannel.access$100(this.this$0, l2, false);
                        channelFuture.addListener(new AbstractHttp2StreamChannel$Http2ChannelUnsafe$3(this, channelPromise, l2));
                        this.writeDoneAndNoFlush = true;
                    }
                    return;
                }
            } else {
                String string = object.toString();
                ReferenceCountUtil.release(object);
                channelPromise.setFailure(new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + string));
                return;
            }
            object2 = this.this$0.write0(this.this$0.parentContext(), object);
            if (object2.isDone()) {
                this.writeComplete((ChannelFuture)object2, channelPromise);
            } else {
                long l10 = AbstractHttp2StreamChannel$FlowControlledFrameSizeEstimator.access$1600().size(object);
                AbstractHttp2StreamChannel.access$100(this.this$0, l10, false);
                object2.addListener(new AbstractHttp2StreamChannel$Http2ChannelUnsafe$4(this, channelPromise, l10));
                this.writeDoneAndNoFlush = true;
            }
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
    }

    private void firstWriteComplete(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        if (throwable == null) {
            channelPromise.setSuccess();
        } else {
            this.closeForcibly();
            channelPromise.setFailure(this.wrapStreamClosedError(throwable));
        }
    }

    private void writeComplete(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        if (throwable == null) {
            channelPromise.setSuccess();
        } else {
            Throwable throwable2 = this.wrapStreamClosedError(throwable);
            if (throwable2 instanceof IOException) {
                if (AbstractHttp2StreamChannel.access$1900(this.this$0).isAutoClose()) {
                    this.closeForcibly();
                } else {
                    AbstractHttp2StreamChannel.access$802(this.this$0, true);
                }
            }
            channelPromise.setFailure(throwable2);
        }
    }

    private Throwable wrapStreamClosedError(Throwable throwable) {
        if (throwable instanceof Http2Exception && ((Http2Exception)throwable).error() == Http2Error.STREAM_CLOSED) {
            return new ClosedChannelException().initCause(throwable);
        }
        return throwable;
    }

    private Http2StreamFrame validateStreamFrame(Http2StreamFrame http2StreamFrame) {
        if (http2StreamFrame.stream() != null && http2StreamFrame.stream() != AbstractHttp2StreamChannel.access$600(this.this$0)) {
            String string = http2StreamFrame.toString();
            ReferenceCountUtil.release(http2StreamFrame);
            throw new IllegalArgumentException("Stream " + http2StreamFrame.stream() + " must not be set on the frame: " + string);
        }
        return http2StreamFrame;
    }

    @Override
    public void flush() {
        if (!this.writeDoneAndNoFlush || this.this$0.isParentReadInProgress()) {
            return;
        }
        try {
            this.this$0.flush0(this.this$0.parentContext());
        }
        finally {
            this.writeDoneAndNoFlush = false;
        }
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.unsafeVoidPromise;
    }

    @Override
    public ChannelOutboundBuffer outboundBuffer() {
        return null;
    }

    /* synthetic */ AbstractHttp2StreamChannel$Http2ChannelUnsafe(AbstractHttp2StreamChannel abstractHttp2StreamChannel, AbstractHttp2StreamChannel$1 abstractHttp2StreamChannel$1) {
        this(abstractHttp2StreamChannel);
    }

    static /* synthetic */ void access$1000(AbstractHttp2StreamChannel$Http2ChannelUnsafe abstractHttp2StreamChannel$Http2ChannelUnsafe, ChannelPromise channelPromise) {
        abstractHttp2StreamChannel$Http2ChannelUnsafe.safeSetSuccess(channelPromise);
    }

    static /* synthetic */ void access$1700(AbstractHttp2StreamChannel$Http2ChannelUnsafe abstractHttp2StreamChannel$Http2ChannelUnsafe, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        abstractHttp2StreamChannel$Http2ChannelUnsafe.firstWriteComplete(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$1800(AbstractHttp2StreamChannel$Http2ChannelUnsafe abstractHttp2StreamChannel$Http2ChannelUnsafe, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        abstractHttp2StreamChannel$Http2ChannelUnsafe.writeComplete(channelFuture, channelPromise);
    }
}

