/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilterProvider;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Iterator;
import java.util.Map;

public final class PerMessageDeflateServerExtensionHandshaker
implements WebSocketServerExtensionHandshaker {
    public static final int MIN_WINDOW_SIZE = 8;
    public static final int MAX_WINDOW_SIZE = 15;
    static final String PERMESSAGE_DEFLATE_EXTENSION = "permessage-deflate";
    static final String CLIENT_MAX_WINDOW = "client_max_window_bits";
    static final String SERVER_MAX_WINDOW = "server_max_window_bits";
    static final String CLIENT_NO_CONTEXT = "client_no_context_takeover";
    static final String SERVER_NO_CONTEXT = "server_no_context_takeover";
    private final int compressionLevel;
    private final boolean allowServerWindowSize;
    private final int preferredClientWindowSize;
    private final boolean allowServerNoContext;
    private final boolean preferredClientNoContext;
    private final WebSocketExtensionFilterProvider extensionFilterProvider;

    public PerMessageDeflateServerExtensionHandshaker() {
        this(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
    }

    public PerMessageDeflateServerExtensionHandshaker(int n4, boolean bl3, int n7, boolean bl4, boolean bl5) {
        this(n4, bl3, n7, bl4, bl5, WebSocketExtensionFilterProvider.DEFAULT);
    }

    public PerMessageDeflateServerExtensionHandshaker(int n4, boolean bl3, int n7, boolean bl4, boolean bl5, WebSocketExtensionFilterProvider webSocketExtensionFilterProvider) {
        if (n7 > 15 || n7 < 8) {
            throw new IllegalArgumentException("preferredServerWindowSize: " + n7 + " (expected: 8-15)");
        }
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        this.compressionLevel = n4;
        this.allowServerWindowSize = bl3;
        this.preferredClientWindowSize = n7;
        this.allowServerNoContext = bl4;
        this.preferredClientNoContext = bl5;
        this.extensionFilterProvider = ObjectUtil.checkNotNull(webSocketExtensionFilterProvider, "extensionFilterProvider");
    }

    @Override
    public WebSocketServerExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!PERMESSAGE_DEFLATE_EXTENSION.equals(webSocketExtensionData.name())) {
            return null;
        }
        boolean bl3 = true;
        int n4 = 15;
        int n7 = 15;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator<Map.Entry<String, String>> iterator = webSocketExtensionData.parameters().entrySet().iterator();
        while (bl3 && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (CLIENT_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                n4 = this.preferredClientWindowSize;
                continue;
            }
            if (SERVER_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerWindowSize) {
                    n7 = Integer.parseInt(entry.getValue());
                    if (n7 <= 15 && n7 >= 8) continue;
                    bl3 = false;
                    continue;
                }
                bl3 = false;
                continue;
            }
            if (CLIENT_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                bl5 = this.preferredClientNoContext;
                continue;
            }
            if (SERVER_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerNoContext) {
                    bl4 = true;
                    continue;
                }
                bl3 = false;
                continue;
            }
            bl3 = false;
        }
        if (bl3) {
            return new PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension(this.compressionLevel, bl4, n7, bl5, n4, this.extensionFilterProvider);
        }
        return null;
    }
}

