/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilterProvider;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker$PermessageDeflateExtension;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class PerMessageDeflateClientExtensionHandshaker
implements WebSocketClientExtensionHandshaker {
    private final int compressionLevel;
    private final boolean allowClientWindowSize;
    private final int requestedServerWindowSize;
    private final boolean allowClientNoContext;
    private final boolean requestedServerNoContext;
    private final WebSocketExtensionFilterProvider extensionFilterProvider;

    public PerMessageDeflateClientExtensionHandshaker() {
        this(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
    }

    public PerMessageDeflateClientExtensionHandshaker(int n4, boolean bl3, int n7, boolean bl4, boolean bl5) {
        this(n4, bl3, n7, bl4, bl5, WebSocketExtensionFilterProvider.DEFAULT);
    }

    public PerMessageDeflateClientExtensionHandshaker(int n4, boolean bl3, int n7, boolean bl4, boolean bl5, WebSocketExtensionFilterProvider webSocketExtensionFilterProvider) {
        if (n7 > 15 || n7 < 8) {
            throw new IllegalArgumentException("requestedServerWindowSize: " + n7 + " (expected: 8-15)");
        }
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        this.compressionLevel = n4;
        this.allowClientWindowSize = bl3;
        this.requestedServerWindowSize = n7;
        this.allowClientNoContext = bl4;
        this.requestedServerNoContext = bl5;
        this.extensionFilterProvider = ObjectUtil.checkNotNull(webSocketExtensionFilterProvider, "extensionFilterProvider");
    }

    @Override
    public WebSocketExtensionData newRequestData() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        if (this.requestedServerWindowSize != 15) {
            hashMap.put("server_no_context_takeover", null);
        }
        if (this.allowClientNoContext) {
            hashMap.put("client_no_context_takeover", null);
        }
        if (this.requestedServerWindowSize != 15) {
            hashMap.put("server_max_window_bits", Integer.toString(this.requestedServerWindowSize));
        }
        if (this.allowClientWindowSize) {
            hashMap.put("client_max_window_bits", null);
        }
        return new WebSocketExtensionData("permessage-deflate", hashMap);
    }

    @Override
    public WebSocketClientExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!"permessage-deflate".equals(webSocketExtensionData.name())) {
            return null;
        }
        boolean bl3 = true;
        int n4 = 15;
        int n7 = 15;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator<Map.Entry<String, String>> iterator = webSocketExtensionData.parameters().entrySet().iterator();
        while (bl3 && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if ("client_max_window_bits".equalsIgnoreCase(entry.getKey())) {
                if (this.allowClientWindowSize) {
                    n4 = Integer.parseInt(entry.getValue());
                    continue;
                }
                bl3 = false;
                continue;
            }
            if ("server_max_window_bits".equalsIgnoreCase(entry.getKey())) {
                n7 = Integer.parseInt(entry.getValue());
                if (n4 <= 15 && n4 >= 8) continue;
                bl3 = false;
                continue;
            }
            if ("client_no_context_takeover".equalsIgnoreCase(entry.getKey())) {
                if (this.allowClientNoContext) {
                    bl5 = true;
                    continue;
                }
                bl3 = false;
                continue;
            }
            if ("server_no_context_takeover".equalsIgnoreCase(entry.getKey())) {
                if (this.requestedServerNoContext) {
                    bl4 = true;
                    continue;
                }
                bl3 = false;
                continue;
            }
            bl3 = false;
        }
        if (this.requestedServerNoContext && !bl4 || this.requestedServerWindowSize != n7) {
            bl3 = false;
        }
        if (bl3) {
            return new PerMessageDeflateClientExtensionHandshaker$PermessageDeflateExtension(this, bl4, n7, bl5, n4, this.extensionFilterProvider);
        }
        return null;
    }

    static /* synthetic */ int access$000(PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker) {
        return perMessageDeflateClientExtensionHandshaker.compressionLevel;
    }
}

