/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateEncoder;

class PerFrameDeflateEncoder
extends DeflateEncoder {
    PerFrameDeflateEncoder(int n4, int n7, boolean bl3) {
        super(n4, n7, bl3, WebSocketExtensionFilter.NEVER_SKIP);
    }

    PerFrameDeflateEncoder(int n4, int n7, boolean bl3, WebSocketExtensionFilter webSocketExtensionFilter) {
        super(n4, n7, bl3, webSocketExtensionFilter);
    }

    @Override
    public boolean acceptOutboundMessage(Object object) {
        if (!super.acceptOutboundMessage(object)) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        if (this.extensionEncoderFilter().mustSkip(webSocketFrame)) {
            return false;
        }
        return (object instanceof TextWebSocketFrame || object instanceof BinaryWebSocketFrame || object instanceof ContinuationWebSocketFrame) && webSocketFrame.content().readableBytes() > 0 && (webSocketFrame.rsv() & 4) == 0;
    }

    @Override
    protected int rsv(WebSocketFrame webSocketFrame) {
        return webSocketFrame.rsv() | 4;
    }

    @Override
    protected boolean removeFrameTail(WebSocketFrame webSocketFrame) {
        return true;
    }
}

