/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

abstract class DeflateEncoder
extends WebSocketExtensionEncoder {
    private final int compressionLevel;
    private final int windowSize;
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionEncoderFilter;
    private EmbeddedChannel encoder;

    DeflateEncoder(int n4, int n7, boolean bl3, WebSocketExtensionFilter webSocketExtensionFilter) {
        this.compressionLevel = n4;
        this.windowSize = n7;
        this.noContext = bl3;
        this.extensionEncoderFilter = ObjectUtil.checkNotNull(webSocketExtensionFilter, "extensionEncoderFilter");
    }

    protected WebSocketExtensionFilter extensionEncoderFilter() {
        return this.extensionEncoderFilter;
    }

    protected abstract int rsv(WebSocketFrame var1);

    protected abstract boolean removeFrameTail(WebSocketFrame var1);

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        WebSocketFrame webSocketFrame2;
        ByteBuf byteBuf;
        if (this.encoder == null) {
            this.encoder = new EmbeddedChannel(ZlibCodecFactory.newZlibEncoder(ZlibWrapper.NONE, this.compressionLevel, this.windowSize, 8));
        }
        this.encoder.writeOutbound(webSocketFrame.content().retain());
        CompositeByteBuf compositeByteBuf = channelHandlerContext.alloc().compositeBuffer();
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            compositeByteBuf.addComponent(true, byteBuf);
        }
        if (compositeByteBuf.numComponents() <= 0) {
            compositeByteBuf.release();
            throw new CodecException("cannot read compressed buffer");
        }
        if (webSocketFrame.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        if (this.removeFrameTail(webSocketFrame)) {
            int n4 = compositeByteBuf.readableBytes() - PerMessageDeflateDecoder.FRAME_TAIL.readableBytes();
            byteBuf = compositeByteBuf.slice(0, n4);
        } else {
            byteBuf = compositeByteBuf;
        }
        if (webSocketFrame instanceof TextWebSocketFrame) {
            webSocketFrame2 = new TextWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            webSocketFrame2 = new BinaryWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            webSocketFrame2 = new ContinuationWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else {
            throw new CodecException("unexpected frame type: " + webSocketFrame.getClass().getName());
        }
        list.add(webSocketFrame2);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    private void cleanup() {
        if (this.encoder != null) {
            if (this.encoder.finish()) {
                ByteBuf byteBuf;
                while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
                    byteBuf.release();
                }
            }
            this.encoder = null;
        }
    }
}

