/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.CodecException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

abstract class DeflateDecoder
extends WebSocketExtensionDecoder {
    static final ByteBuf FRAME_TAIL = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{0, 0, -1, -1})).asReadOnly();
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionDecoderFilter;
    private EmbeddedChannel decoder;

    DeflateDecoder(boolean bl3, WebSocketExtensionFilter webSocketExtensionFilter) {
        this.noContext = bl3;
        this.extensionDecoderFilter = ObjectUtil.checkNotNull(webSocketExtensionFilter, "extensionDecoderFilter");
    }

    protected WebSocketExtensionFilter extensionDecoderFilter() {
        return this.extensionDecoderFilter;
    }

    protected abstract boolean appendFrameTail(WebSocketFrame var1);

    protected abstract int newRsv(WebSocketFrame var1);

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        ReferenceCounted referenceCounted;
        if (this.decoder == null) {
            if (!(webSocketFrame instanceof TextWebSocketFrame) && !(webSocketFrame instanceof BinaryWebSocketFrame)) {
                throw new CodecException("unexpected initial frame type: " + webSocketFrame.getClass().getName());
            }
            this.decoder = new EmbeddedChannel(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.NONE));
        }
        boolean bl3 = webSocketFrame.content().isReadable();
        this.decoder.writeInbound(webSocketFrame.content().retain());
        if (this.appendFrameTail(webSocketFrame)) {
            this.decoder.writeInbound(FRAME_TAIL.duplicate());
        }
        CompositeByteBuf compositeByteBuf = channelHandlerContext.alloc().compositeBuffer();
        while ((referenceCounted = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!referenceCounted.isReadable()) {
                referenceCounted.release();
                continue;
            }
            compositeByteBuf.addComponent(true, (ByteBuf)referenceCounted);
        }
        if (bl3 && compositeByteBuf.numComponents() <= 0) {
            compositeByteBuf.release();
            throw new CodecException("cannot read uncompressed buffer");
        }
        if (webSocketFrame.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        if (webSocketFrame instanceof TextWebSocketFrame) {
            referenceCounted = new TextWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), compositeByteBuf);
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            referenceCounted = new BinaryWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), compositeByteBuf);
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            referenceCounted = new ContinuationWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), compositeByteBuf);
        } else {
            throw new CodecException("unexpected frame type: " + webSocketFrame.getClass().getName());
        }
        list.add(referenceCounted);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    private void cleanup() {
        if (this.decoder != null) {
            if (this.decoder.finish()) {
                ByteBuf byteBuf;
                while ((byteBuf = (ByteBuf)this.decoder.readOutbound()) != null) {
                    byteBuf.release();
                }
            }
            this.decoder = null;
        }
    }
}

