/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil$2;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SuppressJava6Requirement;
import java.security.MessageDigest;
import java.util.Base64;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new WebSocketUtil$1();
    private static final FastThreadLocal<MessageDigest> SHA1 = new WebSocketUtil$2();

    static byte[] md5(byte[] byArray) {
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] byArray) {
        return WebSocketUtil.digest(SHA1, byArray);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> fastThreadLocal, byte[] byArray) {
        MessageDigest messageDigest = fastThreadLocal.get();
        messageDigest.reset();
        return messageDigest.digest(byArray);
    }

    @SuppressJava6Requirement(reason="Guarded with java version check")
    static String base64(byte[] byArray) {
        if (PlatformDependent.javaVersion() >= 8) {
            return Base64.getEncoder().encodeToString(byArray);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        ByteBuf byteBuf2 = io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64.encode(byteBuf);
        String string = byteBuf2.toString(CharsetUtil.UTF_8);
        byteBuf2.release();
        return string;
    }

    static byte[] randomBytes(int n4) {
        byte[] byArray = new byte[n4];
        PlatformDependent.threadLocalRandom().nextBytes(byArray);
        return byArray;
    }

    static int randomNumber(int n4, int n7) {
        assert (n4 < n7);
        double d8 = PlatformDependent.threadLocalRandom().nextDouble();
        return (int)((double)n4 + d8 * (double)(n7 - n4));
    }

    private WebSocketUtil() {
    }
}

