/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$3;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final String websocketPath;
    private final String subprotocols;
    private final boolean checkStartsWith;
    private final long handshakeTimeoutMillis;
    private final WebSocketDecoderConfig decoderConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;

    WebSocketServerProtocolHandshakeHandler(String string, String string2, boolean bl3, long l2, WebSocketDecoderConfig webSocketDecoderConfig) {
        this.websocketPath = string;
        this.subprotocols = string2;
        this.checkStartsWith = bl3;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l2, "handshakeTimeoutMillis");
        this.decoderConfig = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.handshakePromise = channelHandlerContext.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        FullHttpRequest fullHttpRequest = (FullHttpRequest)object;
        if (this.isNotWebSocketPath(fullHttpRequest)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        try {
            if (!HttpMethod.GET.equals(fullHttpRequest.method())) {
                WebSocketServerProtocolHandshakeHandler.sendHttpResponse(channelHandlerContext, fullHttpRequest, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, channelHandlerContext.alloc().buffer(0)));
                return;
            }
            WebSocketServerHandshakerFactory webSocketServerHandshakerFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(channelHandlerContext.pipeline(), fullHttpRequest, this.websocketPath), this.subprotocols, this.decoderConfig);
            WebSocketServerHandshaker webSocketServerHandshaker = webSocketServerHandshakerFactory.newHandshaker(fullHttpRequest);
            ChannelPromise channelPromise = this.handshakePromise;
            if (webSocketServerHandshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channelHandlerContext.channel());
            } else {
                ChannelFuture channelFuture = webSocketServerHandshaker.handshake(channelHandlerContext.channel(), fullHttpRequest);
                channelFuture.addListener(new WebSocketServerProtocolHandshakeHandler$1(this, channelPromise, channelHandlerContext, fullHttpRequest, webSocketServerHandshaker));
                this.applyHandshakeTimeout();
                WebSocketServerProtocolHandler.setHandshaker(channelHandlerContext.channel(), webSocketServerHandshaker);
                channelHandlerContext.pipeline().replace(this, "WS403Responder", WebSocketServerProtocolHandler.forbiddenHttpRequestResponder());
            }
        }
        finally {
            fullHttpRequest.release();
        }
    }

    private boolean isNotWebSocketPath(FullHttpRequest fullHttpRequest) {
        return this.checkStartsWith ? !fullHttpRequest.uri().startsWith(this.websocketPath) : !fullHttpRequest.uri().equals(this.websocketPath);
    }

    private static void sendHttpResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponse httpResponse) {
        ChannelFuture channelFuture = channelHandlerContext.channel().writeAndFlush(httpResponse);
        if (!HttpUtil.isKeepAlive(httpRequest) || httpResponse.status().code() != 200) {
            channelFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline channelPipeline, HttpRequest httpRequest, String string) {
        String string2 = "ws";
        if (channelPipeline.get(SslHandler.class) != null) {
            string2 = "wss";
        }
        String string3 = httpRequest.headers().get(HttpHeaderNames.HOST);
        return string2 + "://" + string3 + string;
    }

    private void applyHandshakeTimeout() {
        ChannelPromise channelPromise = this.handshakePromise;
        long l2 = this.handshakeTimeoutMillis;
        if (l2 <= 0L || channelPromise.isDone()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new WebSocketServerProtocolHandshakeHandler$2(this, channelPromise), l2, TimeUnit.MILLISECONDS);
        channelPromise.addListener(new WebSocketServerProtocolHandshakeHandler$3(this, scheduledFuture));
    }

    static /* synthetic */ ChannelHandlerContext access$000(WebSocketServerProtocolHandshakeHandler webSocketServerProtocolHandshakeHandler) {
        return webSocketServerProtocolHandshakeHandler.ctx;
    }
}

