/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocketServerProtocolHandler
extends WebSocketProtocolHandler {
    private static final AttributeKey<WebSocketServerHandshaker> HANDSHAKER_ATTR_KEY = AttributeKey.valueOf(WebSocketServerHandshaker.class, "HANDSHAKER");
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MS = 10000L;
    private final String websocketPath;
    private final String subprotocols;
    private final boolean checkStartsWith;
    private final long handshakeTimeoutMillis;
    private final WebSocketDecoderConfig decoderConfig;

    public WebSocketServerProtocolHandler(String string) {
        this(string, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, long l2) {
        this(string, null, false);
    }

    public WebSocketServerProtocolHandler(String string, boolean bl3) {
        this(string, bl3, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, boolean bl3, long l2) {
        this(string, null, false, 65536, false, bl3, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2) {
        this(string, string2, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, long l2) {
        this(string, string2, false, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3) {
        this(string, string2, bl3, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, long l2) {
        this(string, string2, bl3, 65536, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4) {
        this(string, string2, bl3, n4, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, long l2) {
        this(string, string2, bl3, n4, false, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4) {
        this(string, string2, bl3, n4, bl4, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4, long l2) {
        this(string, string2, bl3, n4, bl4, false, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4, boolean bl5) {
        this(string, string2, bl3, n4, bl4, bl5, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4, boolean bl5, long l2) {
        this(string, string2, bl3, n4, bl4, bl5, true, l2);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4, boolean bl5, boolean bl6) {
        this(string, string2, bl3, n4, bl4, bl5, bl6, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, int n4, boolean bl4, boolean bl5, boolean bl6, long l2) {
        this(string, string2, bl5, bl6, l2, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n4).allowMaskMismatch(bl4).allowExtensions(bl3).build());
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl3, boolean bl4, long l2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(bl4);
        this.websocketPath = string;
        this.subprotocols = string2;
        this.checkStartsWith = bl3;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l2, "handshakeTimeoutMillis");
        this.decoderConfig = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketServerProtocolHandshakeHandler.class) == null) {
            channelPipeline.addBefore(channelHandlerContext.name(), WebSocketServerProtocolHandshakeHandler.class.getName(), new WebSocketServerProtocolHandshakeHandler(this.websocketPath, this.subprotocols, this.checkStartsWith, this.handshakeTimeoutMillis, this.decoderConfig));
        }
        if (channelPipeline.get(Utf8FrameValidator.class) == null) {
            channelPipeline.addBefore(channelHandlerContext.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            WebSocketServerHandshaker webSocketServerHandshaker = WebSocketServerProtocolHandler.getHandshaker(channelHandlerContext.channel());
            if (webSocketServerHandshaker != null) {
                webSocketFrame.retain();
                webSocketServerHandshaker.close(channelHandlerContext.channel(), (CloseWebSocketFrame)webSocketFrame);
            } else {
                channelHandlerContext.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, list);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof WebSocketHandshakeException) {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer(throwable.getMessage().getBytes()));
            channelHandlerContext.channel().writeAndFlush(defaultFullHttpResponse).addListener(ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
            channelHandlerContext.close();
        }
    }

    static WebSocketServerHandshaker getHandshaker(Channel channel) {
        return channel.attr(HANDSHAKER_ATTR_KEY).get();
    }

    static void setHandshaker(Channel channel, WebSocketServerHandshaker webSocketServerHandshaker) {
        channel.attr(HANDSHAKER_ATTR_KEY).set(webSocketServerHandshaker);
    }

    static ChannelHandler forbiddenHttpRequestResponder() {
        return new WebSocketServerProtocolHandler$1();
    }
}

