/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.regex.Pattern;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final Pattern BEGINNING_DIGIT = Pattern.compile("[^0-9]");
    private static final Pattern BEGINNING_SPACE = Pattern.compile("[^ ]");

    public WebSocketServerHandshaker00(String string, String string2, int n4) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n4).build());
    }

    public WebSocketServerHandshaker00(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(WebSocketVersion.V00, string, string2, webSocketDecoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest fullHttpRequest, HttpHeaders httpHeaders) {
        if (!fullHttpRequest.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true) || !HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean bl3 = fullHttpRequest.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && fullHttpRequest.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2);
        String string = fullHttpRequest.headers().get(HttpHeaderNames.ORIGIN);
        if (string == null && !bl3) {
            throw new WebSocketHandshakeException("Missing origin header, got only " + fullHttpRequest.headers().names());
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, bl3 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"), fullHttpRequest.content().alloc().buffer(0));
        if (httpHeaders != null) {
            defaultFullHttpResponse.headers().add(httpHeaders);
        }
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        if (bl3) {
            String string2;
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)string);
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION, (Object)this.uri());
            String string3 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
            if (string3 != null) {
                string2 = this.selectSubprotocol(string3);
                if (string2 == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Requested subprotocol(s) not supported: {}", (Object)string3);
                    }
                } else {
                    defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string2);
                }
            }
            string2 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY1);
            String string4 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY2);
            int n4 = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(string2).replaceAll("")) / (long)BEGINNING_SPACE.matcher(string2).replaceAll("").length());
            int n7 = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(string4).replaceAll("")) / (long)BEGINNING_SPACE.matcher(string4).replaceAll("").length());
            long l2 = fullHttpRequest.content().readLong();
            ByteBuf byteBuf = Unpooled.wrappedBuffer(new byte[16]).setIndex(0, 0);
            byteBuf.writeInt(n4);
            byteBuf.writeInt(n7);
            byteBuf.writeLong(l2);
            defaultFullHttpResponse.content().writeBytes(WebSocketUtil.md5(byteBuf.array()));
        } else {
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.WEBSOCKET_ORIGIN, (Object)string);
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.WEBSOCKET_LOCATION, (Object)this.uri());
            String string5 = fullHttpRequest.headers().get(HttpHeaderNames.WEBSOCKET_PROTOCOL);
            if (string5 != null) {
                defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL, (Object)this.selectSubprotocol(string5));
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }
}

