/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketFrameAggregator
extends MessageAggregator<WebSocketFrame, WebSocketFrame, ContinuationWebSocketFrame, WebSocketFrame> {
    public WebSocketFrameAggregator(int n4) {
        super(n4);
    }

    @Override
    protected boolean isStartMessage(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame;
    }

    @Override
    protected boolean isContentMessage(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof ContinuationWebSocketFrame;
    }

    @Override
    protected boolean isLastContentMessage(ContinuationWebSocketFrame continuationWebSocketFrame) {
        return this.isContentMessage(continuationWebSocketFrame) && continuationWebSocketFrame.isFinalFragment();
    }

    @Override
    protected boolean isAggregated(WebSocketFrame webSocketFrame) {
        if (webSocketFrame.isFinalFragment()) {
            return !this.isContentMessage(webSocketFrame);
        }
        return !this.isStartMessage(webSocketFrame) && !this.isContentMessage(webSocketFrame);
    }

    @Override
    protected boolean isContentLengthInvalid(WebSocketFrame webSocketFrame, int n4) {
        return false;
    }

    @Override
    protected Object newContinueResponse(WebSocketFrame webSocketFrame, int n4, ChannelPipeline channelPipeline) {
        return null;
    }

    @Override
    public boolean closeAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ignoreContentAfterContinueResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected WebSocketFrame beginAggregation(WebSocketFrame webSocketFrame, ByteBuf byteBuf) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            return new TextWebSocketFrame(true, webSocketFrame.rsv(), byteBuf);
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return new BinaryWebSocketFrame(true, webSocketFrame.rsv(), byteBuf);
        }
        throw new Error();
    }
}

