/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.util.List;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MS = 10000L;
    private final WebSocketClientHandshaker handshaker;
    private final boolean handleCloseFrames;
    private final long handshakeTimeoutMillis;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, boolean bl6) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl4, bl5, bl6, 10000L);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, boolean bl6, long l2) {
        this(WebSocketClientHandshakerFactory.newHandshaker(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl5, bl6), bl4, l2);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl4, 10000L);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, long l2) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl4, true, false, l2);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, 10000L);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, long l2) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, true, l2);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl3) {
        this(webSocketClientHandshaker, bl3, 10000L);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl3, long l2) {
        this(webSocketClientHandshaker, bl3, true, l2);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl3, boolean bl4) {
        this(webSocketClientHandshaker, bl3, bl4, 10000L);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl3, boolean bl4, long l2) {
        super(bl4);
        this.handshaker = webSocketClientHandshaker;
        this.handleCloseFrames = bl3;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l2, "handshakeTimeoutMillis");
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker) {
        this(webSocketClientHandshaker, 10000L);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, long l2) {
        this(webSocketClientHandshaker, true, l2);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (this.handleCloseFrames && webSocketFrame instanceof CloseWebSocketFrame) {
            channelHandlerContext.close();
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, list);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker, this.handshakeTimeoutMillis));
        }
        if (channelPipeline.get(Utf8FrameValidator.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
    }
}

