/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;

public final class WebSocketClientHandshakerFactory {
    private WebSocketClientHandshakerFactory() {
    }

    public static WebSocketClientHandshaker newHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders) {
        return WebSocketClientHandshakerFactory.newHandshaker(uRI, webSocketVersion, string, bl3, httpHeaders, 65536);
    }

    public static WebSocketClientHandshaker newHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4) {
        return WebSocketClientHandshakerFactory.newHandshaker(uRI, webSocketVersion, string, bl3, httpHeaders, n4, true, false);
    }

    public static WebSocketClientHandshaker newHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5) {
        return WebSocketClientHandshakerFactory.newHandshaker(uRI, webSocketVersion, string, bl3, httpHeaders, n4, true, false, -1L);
    }

    public static WebSocketClientHandshaker newHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, long l2) {
        if (webSocketVersion == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(uRI, WebSocketVersion.V13, string, bl3, httpHeaders, n4, bl4, bl5, l2);
        }
        if (webSocketVersion == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(uRI, WebSocketVersion.V08, string, bl3, httpHeaders, n4, bl4, bl5, l2);
        }
        if (webSocketVersion == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(uRI, WebSocketVersion.V07, string, bl3, httpHeaders, n4, bl4, bl5, l2);
        }
        if (webSocketVersion == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(uRI, WebSocketVersion.V00, string, httpHeaders, n4, l2);
        }
        throw new WebSocketHandshakeException("Protocol version " + (Object)((Object)webSocketVersion) + " not supported.");
    }

    public static WebSocketClientHandshaker newHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, long l2, boolean bl6) {
        if (webSocketVersion == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(uRI, WebSocketVersion.V13, string, bl3, httpHeaders, n4, bl4, bl5, l2, bl6);
        }
        if (webSocketVersion == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(uRI, WebSocketVersion.V08, string, bl3, httpHeaders, n4, bl4, bl5, l2, bl6);
        }
        if (webSocketVersion == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(uRI, WebSocketVersion.V07, string, bl3, httpHeaders, n4, bl4, bl5, l2, bl6);
        }
        if (webSocketVersion == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(uRI, WebSocketVersion.V00, string, httpHeaders, n4, l2, bl6);
        }
        throw new WebSocketHandshakeException("Protocol version " + (Object)((Object)webSocketVersion) + " not supported.");
    }
}

