/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker08
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker08.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, true, false, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl4, bl5, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, long l2) {
        this(uRI, webSocketVersion, string, bl3, httpHeaders, n4, bl4, bl5, l2, false);
    }

    WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl3, HttpHeaders httpHeaders, int n4, boolean bl4, boolean bl5, long l2, boolean bl6) {
        super(uRI, webSocketVersion, string, httpHeaders, n4, l2, bl6);
        this.allowExtensions = bl3;
        this.performMasking = bl4;
        this.allowMaskMismatch = bl5;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        URI uRI = this.uri();
        byte[] byArray = WebSocketUtil.randomBytes(16);
        String string = WebSocketUtil.base64(byArray);
        String string2 = string + MAGIC_GUID;
        byte[] byArray2 = WebSocketUtil.sha1(string2.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(byArray2);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 08 client handshake key: {}, expected response: {}", (Object)string, (Object)this.expectedChallengeResponseString);
        }
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(uRI), Unpooled.EMPTY_BUFFER);
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)string).set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker08.websocketHostValue(uRI)).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)WebSocketClientHandshaker08.websocketOriginValue(uRI));
        String string3 = this.expectedSubprotocol();
        if (string3 != null && !string3.isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string3);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"8");
        return defaultFullHttpRequest;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        if (!fullHttpResponse.status().equals(httpResponseStatus)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + fullHttpResponse.status());
        }
        String string = httpHeaders.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(string)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + string);
        }
        if (!httpHeaders.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + httpHeaders.get(HttpHeaderNames.CONNECTION));
        }
        String string2 = httpHeaders.get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (string2 == null || !string2.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", string2, this.expectedChallengeResponseString));
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket08FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket08FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker08 setForceCloseTimeoutMillis(long l2) {
        super.setForceCloseTimeoutMillis(l2);
        return this;
    }
}

