/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.net.URI;
import java.nio.ByteBuffer;

public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private static final AsciiString WEBSOCKET = AsciiString.cached("WebSocket");
    private ByteBuf expectedChallengeResponseBytes;

    public WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4) {
        this(uRI, webSocketVersion, string, httpHeaders, n4, 10000L);
    }

    public WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4, long l2) {
        this(uRI, webSocketVersion, string, httpHeaders, n4, l2, false);
    }

    WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4, long l2, boolean bl3) {
        super(uRI, webSocketVersion, string, httpHeaders, n4, l2, bl3);
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        int n4 = WebSocketUtil.randomNumber(1, 12);
        int n7 = WebSocketUtil.randomNumber(1, 12);
        int n8 = Integer.MAX_VALUE / n4;
        int n10 = Integer.MAX_VALUE / n7;
        int n11 = WebSocketUtil.randomNumber(0, n8);
        int n12 = WebSocketUtil.randomNumber(0, n10);
        int n13 = n11 * n4;
        int n14 = n12 * n7;
        String string = Integer.toString(n13);
        String string2 = Integer.toString(n14);
        string = WebSocketClientHandshaker00.insertRandomCharacters(string);
        string2 = WebSocketClientHandshaker00.insertRandomCharacters(string2);
        string = WebSocketClientHandshaker00.insertSpaces(string, n4);
        string2 = WebSocketClientHandshaker00.insertSpaces(string2, n7);
        byte[] byArray = WebSocketUtil.randomBytes(8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n11);
        byte[] byArray2 = byteBuffer.array();
        byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n12);
        byte[] byArray3 = byteBuffer.array();
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray2, 0, byArray4, 0, 4);
        System.arraycopy(byArray3, 0, byArray4, 4, 4);
        System.arraycopy(byArray, 0, byArray4, 8, 8);
        this.expectedChallengeResponseBytes = Unpooled.wrappedBuffer(WebSocketUtil.md5(byArray4));
        URI uRI = this.uri();
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(uRI), Unpooled.wrappedBuffer(byArray));
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker00.websocketHostValue(uRI)).set((CharSequence)HttpHeaderNames.ORIGIN, (Object)WebSocketClientHandshaker00.websocketOriginValue(uRI)).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)string).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2, (Object)string2);
        String string3 = this.expectedSubprotocol();
        if (string3 != null && !string3.isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string3);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byArray.length);
        return defaultFullHttpRequest;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        if (!fullHttpResponse.status().equals(HttpResponseStatus.SWITCHING_PROTOCOLS)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + fullHttpResponse.status());
        }
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        String string = httpHeaders.get(HttpHeaderNames.UPGRADE);
        if (!WEBSOCKET.contentEqualsIgnoreCase(string)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + string);
        }
        if (!httpHeaders.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + httpHeaders.get(HttpHeaderNames.CONNECTION));
        }
        ByteBuf byteBuf = fullHttpResponse.content();
        if (!byteBuf.equals(this.expectedChallengeResponseBytes)) {
            throw new WebSocketHandshakeException("Invalid challenge");
        }
    }

    private static String insertRandomCharacters(String string) {
        int n4;
        int n7 = WebSocketUtil.randomNumber(1, 12);
        char[] cArray = new char[n7];
        int n8 = 0;
        while (n8 < n7) {
            n4 = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= n4 || n4 >= 47) && (58 >= n4 || n4 >= 126)) continue;
            cArray[n8] = (char)n4;
            ++n8;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            int n10 = WebSocketUtil.randomNumber(0, string.length());
            String string2 = string.substring(0, n10);
            String string3 = string.substring(n10);
            string = string2 + cArray[n4] + string3;
        }
        return string;
    }

    private static String insertSpaces(String string, int n4) {
        for (int i3 = 0; i3 < n4; ++i3) {
            int n7 = WebSocketUtil.randomNumber(1, string.length() - 1);
            String string2 = string.substring(0, n7);
            String string3 = string.substring(n7);
            string = string2 + ' ' + string3;
        }
        return string;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }

    @Override
    public WebSocketClientHandshaker00 setForceCloseTimeoutMillis(long l2) {
        super.setForceCloseTimeoutMillis(l2);
        return this;
    }
}

