/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequestEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpScheme;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$3;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$4;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$5;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class WebSocketClientHandshaker {
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4) {
        this(uRI, webSocketVersion, string, httpHeaders, n4, 10000L);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4, long l2) {
        this(uRI, webSocketVersion, string, httpHeaders, n4, l2, false);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n4, long l2, boolean bl3) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n4;
        this.forceCloseTimeoutMillis = l2;
        this.absoluteUpgradeUrl = bl3;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    public WebSocketClientHandshaker setForceCloseTimeoutMillis(long l2) {
        this.forceCloseTimeoutMillis = l2;
        return this;
    }

    public ChannelFuture handshake(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.handshake(channel, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, ChannelPromise channelPromise) {
        Object object;
        ChannelPipeline channelPipeline = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = channelPipeline.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (object = channelPipeline.get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        object = this.newHandshakeRequest();
        channel.writeAndFlush(object).addListener(new WebSocketClientHandshaker$1(this, channelPromise));
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse fullHttpResponse) {
        ChannelHandlerContext channelHandlerContext;
        HttpObjectAggregator httpObjectAggregator;
        this.verify(fullHttpResponse);
        String string = fullHttpResponse.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string = string != null ? string.trim() : null;
        String string2 = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl3 = false;
        if (string2.isEmpty() && string == null) {
            bl3 = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!string2.isEmpty() && string != null && !string.isEmpty()) {
            for (String object2 : string2.split(",")) {
                if (!object2.trim().equals(string)) continue;
                bl3 = true;
                this.setActualSubprotocol(string);
                break;
            }
        }
        if (!bl3) {
            throw new WebSocketHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string, this.expectedSubprotocol));
        }
        this.setHandshakeComplete();
        String[] stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove(httpContentDecompressor);
        }
        if ((httpObjectAggregator = stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove(httpObjectAggregator);
        }
        if ((channelHandlerContext = stringArray.context(HttpResponseDecoder.class)) == null) {
            ChannelHandlerContext channelHandlerContext2 = stringArray.context(HttpClientCodec.class);
            if (channelHandlerContext2 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain a HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec httpClientCodec = (HttpClientCodec)channelHandlerContext2.handler();
            httpClientCodec.removeOutboundHandler();
            stringArray.addAfter(channelHandlerContext2.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new WebSocketClientHandshaker$2(this, (ChannelPipeline)stringArray, httpClientCodec));
        } else {
            if (stringArray.get(HttpRequestEncoder.class) != null) {
                stringArray.remove(HttpRequestEncoder.class);
            }
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            stringArray.addAfter(channelHandlerContext3.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new WebSocketClientHandshaker$3(this, (ChannelPipeline)stringArray, channelHandlerContext3));
        }
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse, ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context(HttpClientCodec.class)) == null) {
                return channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            }
            String string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
            channelPipeline.addAfter(string, "handshaker", new WebSocketClientHandshaker$4(this, channel, channelPromise));
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        channel.writeAndFlush(closeWebSocketFrame, channelPromise);
        this.applyForceCloseTimeout(channel, channelPromise);
        return channelPromise;
    }

    private void applyForceCloseTimeout(Channel channel, ChannelFuture channelFuture) {
        long l2 = this.forceCloseTimeoutMillis;
        WebSocketClientHandshaker webSocketClientHandshaker = this;
        if (l2 <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return;
        }
        channelFuture.addListener(new WebSocketClientHandshaker$5(this, channel, webSocketClientHandshaker, l2));
    }

    protected String upgradeUrl(URI uRI) {
        if (this.absoluteUpgradeUrl) {
            return uRI.toString();
        }
        String string = uRI.getRawPath();
        String string2 = uRI.getRawQuery();
        if (string2 != null && !string2.isEmpty()) {
            string = string + '?' + string2;
        }
        return string == null || string.isEmpty() ? "/" : string;
    }

    static CharSequence websocketHostValue(URI uRI) {
        int n4 = uRI.getPort();
        if (n4 == -1) {
            return uRI.getHost();
        }
        String string = uRI.getHost();
        String string2 = uRI.getScheme();
        if (n4 == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals(string2) || WebSocketScheme.WS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n4);
        }
        if (n4 == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals(string2) || WebSocketScheme.WSS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n4);
        }
        return NetUtil.toSocketAddressString(string, n4);
    }

    static CharSequence websocketOriginValue(URI uRI) {
        int n4;
        String string;
        String string2 = uRI.getScheme();
        int n7 = uRI.getPort();
        if (WebSocketScheme.WSS.name().contentEquals(string2) || HttpScheme.HTTPS.name().contentEquals(string2) || string2 == null && n7 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n4 = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n4 = WebSocketScheme.WS.port();
        }
        String string3 = uRI.getHost().toLowerCase(Locale.US);
        if (n7 != n4 && n7 != -1) {
            return string + NetUtil.toSocketAddressString(string3, n7);
        }
        return string + string3;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$000() {
        return FORCE_CLOSE_INIT_UPDATER;
    }

    static /* synthetic */ boolean access$102(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl3) {
        webSocketClientHandshaker.forceCloseComplete = bl3;
        return webSocketClientHandshaker.forceCloseComplete;
    }
}

