/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.stream.ChunkedInput;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class WebSocketChunkedInput
implements ChunkedInput<WebSocketFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final int rsv;

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> chunkedInput) {
        this(chunkedInput, 0);
    }

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> chunkedInput, int n4) {
        this.input = ObjectUtil.checkNotNull(chunkedInput, "input");
        this.rsv = n4;
    }

    @Override
    public boolean isEndOfInput() {
        return this.input.isEndOfInput();
    }

    @Override
    public void close() {
        this.input.close();
    }

    @Override
    @Deprecated
    public WebSocketFrame readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    @Override
    public WebSocketFrame readChunk(ByteBufAllocator byteBufAllocator) {
        ByteBuf byteBuf = this.input.readChunk(byteBufAllocator);
        if (byteBuf == null) {
            return null;
        }
        return new ContinuationWebSocketFrame(this.input.isEndOfInput(), this.rsv, byteBuf);
    }

    @Override
    public long length() {
        return this.input.length();
    }

    @Override
    public long progress() {
        return this.input.progress();
    }
}

