/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean bl3) {
        this.maskPayload = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        int n4;
        ByteBuf byteBuf = webSocketFrame.content();
        if (webSocketFrame instanceof TextWebSocketFrame) {
            n4 = 1;
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            n4 = 9;
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            n4 = 10;
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            n4 = 8;
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            n4 = 2;
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            n4 = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + webSocketFrame.getClass().getName());
        }
        int n7 = byteBuf.readableBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("Encoding WebSocket Frame opCode=" + n4 + " length=" + n7);
        }
        int n8 = 0;
        if (webSocketFrame.isFinalFragment()) {
            n8 |= 0x80;
        }
        n8 |= webSocketFrame.rsv() % 8 << 4;
        n8 |= n4 % 128;
        if (n4 == 9 && n7 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n7);
        }
        boolean bl3 = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n10;
            int n11;
            int n12 = n11 = this.maskPayload ? 4 : 0;
            if (n7 <= 125) {
                n10 = 2 + n11;
                if (this.maskPayload || n7 <= 1024) {
                    n10 += n7;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n10);
                ((ByteBuf)referenceCounted).writeByte(n8);
                byte by2 = this.maskPayload ? (byte)(0x80 | (byte)n7) : (byte)n7;
                ((ByteBuf)referenceCounted).writeByte(by2);
            } else if (n7 <= 65535) {
                n10 = 4 + n11;
                if (this.maskPayload || n7 <= 1024) {
                    n10 += n7;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n10);
                ((ByteBuf)referenceCounted).writeByte(n8);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)referenceCounted).writeByte(n7 >>> 8 & 0xFF);
                ((ByteBuf)referenceCounted).writeByte(n7 & 0xFF);
            } else {
                n10 = 10 + n11;
                if (this.maskPayload || n7 <= 1024) {
                    n10 += n7;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n10);
                ((ByteBuf)referenceCounted).writeByte(n8);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)referenceCounted).writeLong(n7);
            }
            if (this.maskPayload) {
                int n13;
                n10 = (int)(Math.random() * 2.147483647E9);
                byte[] byArray = ByteBuffer.allocate(4).putInt(n10).array();
                ((ByteBuf)referenceCounted).writeBytes(byArray);
                ByteOrder byteOrder = byteBuf.order();
                ByteOrder byteOrder2 = ((ByteBuf)referenceCounted).order();
                int n14 = 0;
                int n15 = byteBuf.readerIndex();
                int n16 = byteBuf.writerIndex();
                if (byteOrder == byteOrder2) {
                    n13 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        n13 = Integer.reverseBytes(n13);
                    }
                    while (n15 + 3 < n16) {
                        int n17 = byteBuf.getInt(n15);
                        ((ByteBuf)referenceCounted).writeInt(n17 ^ n13);
                        n15 += 4;
                    }
                }
                while (n15 < n16) {
                    n13 = byteBuf.getByte(n15);
                    ((ByteBuf)referenceCounted).writeByte(n13 ^ byArray[n14++ % 4]);
                    ++n15;
                }
                list.add(referenceCounted);
            } else if (((ByteBuf)referenceCounted).writableBytes() >= byteBuf.readableBytes()) {
                ((ByteBuf)referenceCounted).writeBytes(byteBuf);
                list.add(referenceCounted);
            } else {
                list.add(referenceCounted);
                list.add(byteBuf.retain());
            }
            bl3 = false;
        }
        finally {
            if (bl3 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }
}

