/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.Utf8Validator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameDecoder
extends ByteToMessageDecoder
implements WebSocketFrameDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameDecoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private final WebSocketDecoderConfig config;
    private int fragmentedFramesCount;
    private boolean frameFinalFlag;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private byte[] maskingKey;
    private int framePayloadLen1;
    private boolean receivedClosingHandshake;
    private WebSocket08FrameDecoder$State state = WebSocket08FrameDecoder$State.READING_FIRST;

    public WebSocket08FrameDecoder(boolean bl3, boolean bl4, int n4) {
        this(bl3, bl4, n4, false);
    }

    public WebSocket08FrameDecoder(boolean bl3, boolean bl4, int n4, boolean bl5) {
        this(WebSocketDecoderConfig.newBuilder().expectMaskedFrames(bl3).allowExtensions(bl4).maxFramePayloadLength(n4).allowMaskMismatch(bl5).build());
    }

    public WebSocket08FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.config = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        switch (this.state) {
            case READING_FIRST: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                this.framePayloadLength = 0L;
                byte by2 = byteBuf.readByte();
                this.frameFinalFlag = (by2 & 0x80) != 0;
                this.frameRsv = (by2 & 0x70) >> 4;
                this.frameOpcode = by2 & 0xF;
                if (logger.isDebugEnabled()) {
                    logger.debug("Decoding WebSocket Frame opCode={}", (Object)this.frameOpcode);
                }
                this.state = WebSocket08FrameDecoder$State.READING_SECOND;
            }
            case READING_SECOND: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                byte by2 = byteBuf.readByte();
                this.frameMasked = (by2 & 0x80) != 0;
                this.framePayloadLen1 = by2 & 0x7F;
                if (this.frameRsv != 0 && !this.config.allowExtensions()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    return;
                }
                if (!this.config.allowMaskMismatch() && this.config.expectMaskedFrames() != this.frameMasked) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "received a frame that is not masked as expected");
                    return;
                }
                if (this.frameOpcode > 7) {
                    if (!this.frameFinalFlag) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "fragmented control frame");
                        return;
                    }
                    if (this.framePayloadLen1 > 125) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame with payload length > 125 octets");
                        return;
                    }
                    if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.frameOpcode == 8 && this.framePayloadLen1 == 1) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received close control frame with payload len 1");
                        return;
                    }
                } else {
                    if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "data frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received continuation data frame outside fragmented message");
                        return;
                    }
                    if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0 && this.frameOpcode != 9) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received non-continuation data frame while inside fragmented message");
                        return;
                    }
                }
                this.state = WebSocket08FrameDecoder$State.READING_SIZE;
            }
            case READING_SIZE: {
                if (this.framePayloadLen1 == 126) {
                    if (byteBuf.readableBytes() < 2) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readUnsignedShort();
                    if (this.framePayloadLength < 126L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else if (this.framePayloadLen1 == 127) {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readLong();
                    if (this.framePayloadLength < 65536L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else {
                    this.framePayloadLength = this.framePayloadLen1;
                }
                if (this.framePayloadLength > (long)this.config.maxFramePayloadLength()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.MESSAGE_TOO_BIG, "Max frame length of " + this.config.maxFramePayloadLength() + " has been exceeded.");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Decoding WebSocket Frame length={}", (Object)this.framePayloadLength);
                }
                this.state = WebSocket08FrameDecoder$State.MASKING_KEY;
            }
            case MASKING_KEY: {
                if (this.frameMasked) {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    if (this.maskingKey == null) {
                        this.maskingKey = new byte[4];
                    }
                    byteBuf.readBytes(this.maskingKey);
                }
                this.state = WebSocket08FrameDecoder$State.PAYLOAD;
            }
            case PAYLOAD: {
                if ((long)byteBuf.readableBytes() < this.framePayloadLength) {
                    return;
                }
                ReferenceCounted referenceCounted = null;
                try {
                    referenceCounted = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength));
                    this.state = WebSocket08FrameDecoder$State.READING_FIRST;
                    if (this.frameMasked) {
                        this.unmask((ByteBuf)referenceCounted);
                    }
                    if (this.frameOpcode == 9) {
                        list.add(new PingWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    if (this.frameOpcode == 10) {
                        list.add(new PongWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    if (this.frameOpcode == 8) {
                        this.receivedClosingHandshake = true;
                        this.checkCloseFrameBody(channelHandlerContext, (ByteBuf)referenceCounted);
                        list.add(new CloseWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    if (this.frameFinalFlag) {
                        if (this.frameOpcode != 9) {
                            this.fragmentedFramesCount = 0;
                        }
                    } else {
                        ++this.fragmentedFramesCount;
                    }
                    if (this.frameOpcode == 1) {
                        list.add(new TextWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    if (this.frameOpcode == 2) {
                        list.add(new BinaryWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    if (this.frameOpcode == 0) {
                        list.add(new ContinuationWebSocketFrame(this.frameFinalFlag, this.frameRsv, (ByteBuf)referenceCounted));
                        referenceCounted = null;
                        return;
                    }
                    throw new UnsupportedOperationException("Cannot decode web socket frame with opcode: " + this.frameOpcode);
                }
                finally {
                    if (referenceCounted != null) {
                        referenceCounted.release();
                    }
                }
            }
            case CORRUPT: {
                if (byteBuf.isReadable()) {
                    byteBuf.readByte();
                }
                return;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private void unmask(ByteBuf byteBuf) {
        int n4 = byteBuf.readerIndex();
        int n7 = byteBuf.writerIndex();
        ByteOrder byteOrder = byteBuf.order();
        int n8 = (this.maskingKey[0] & 0xFF) << 24 | (this.maskingKey[1] & 0xFF) << 16 | (this.maskingKey[2] & 0xFF) << 8 | this.maskingKey[3] & 0xFF;
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            n8 = Integer.reverseBytes(n8);
        }
        while (n4 + 3 < n7) {
            int n10 = byteBuf.getInt(n4) ^ n8;
            byteBuf.setInt(n4, n10);
            n4 += 4;
        }
        while (n4 < n7) {
            byteBuf.setByte(n4, byteBuf.getByte(n4) ^ this.maskingKey[n4 % 4]);
            ++n4;
        }
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.PROTOCOL_ERROR, string);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, WebSocketCloseStatus webSocketCloseStatus, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, new CorruptedWebSocketFrameException(webSocketCloseStatus, string));
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        this.state = WebSocket08FrameDecoder$State.CORRUPT;
        int n4 = byteBuf.readableBytes();
        if (n4 > 0) {
            byteBuf.skipBytes(n4);
        }
        if (channelHandlerContext.channel().isActive() && this.config.closeOnProtocolViolation()) {
            ReferenceCounted referenceCounted;
            if (this.receivedClosingHandshake) {
                referenceCounted = Unpooled.EMPTY_BUFFER;
            } else {
                WebSocketCloseStatus webSocketCloseStatus = corruptedWebSocketFrameException.closeStatus();
                String string = corruptedWebSocketFrameException.getMessage();
                if (string == null) {
                    string = webSocketCloseStatus.reasonText();
                }
                referenceCounted = new CloseWebSocketFrame(webSocketCloseStatus, string);
            }
            channelHandlerContext.writeAndFlush(referenceCounted).addListener(ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    private static int toFrameLength(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new TooLongFrameException("Length:" + l2);
        }
        return (int)l2;
    }

    protected void checkCloseFrameBody(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        if (byteBuf.readableBytes() == 1) {
            this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "Invalid close frame body");
        }
        int n4 = byteBuf.readerIndex();
        byteBuf.readerIndex(0);
        short s11 = byteBuf.readShort();
        if (!WebSocketCloseStatus.isValidStatusCode(s11)) {
            this.protocolViolation(channelHandlerContext, byteBuf, "Invalid close frame getStatus code: " + s11);
        }
        if (byteBuf.isReadable()) {
            try {
                new Utf8Validator().check(byteBuf);
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, byteBuf, corruptedWebSocketFrameException);
            }
        }
        byteBuf.readerIndex(n4);
    }
}

