/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    public WebSocket00FrameDecoder(int n4) {
        this.maxFrameSize = n4;
    }

    public WebSocket00FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.maxFrameSize = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig").maxFramePayloadLength();
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        byte by2 = byteBuf.readByte();
        WebSocketFrame webSocketFrame = (by2 & 0x80) == 128 ? this.decodeBinaryFrame(channelHandlerContext, by2, byteBuf) : this.decodeTextFrame(channelHandlerContext, byteBuf);
        if (webSocketFrame != null) {
            list.add(webSocketFrame);
        }
    }

    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext channelHandlerContext, byte by2, ByteBuf byteBuf) {
        byte by3;
        long l2 = 0L;
        int n4 = 0;
        do {
            by3 = byteBuf.readByte();
            l2 <<= 7;
            if ((l2 |= (long)(by3 & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++n4 <= 8) continue;
            throw new TooLongFrameException();
        } while ((by3 & 0x80) == 128);
        if (by2 == -1 && l2 == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame(true, 0, channelHandlerContext.alloc().buffer(0));
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, (int)l2);
        return new BinaryWebSocketFrame(byteBuf2);
    }

    private WebSocketFrame decodeTextFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n4;
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf.indexOf(n7, n7 + (n4 = this.actualReadableBytes()), (byte)-1);
        if (n8 == -1) {
            if ((long)n4 > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int n10 = n8 - n7;
        if ((long)n10 > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, n10);
        byteBuf.skipBytes(1);
        int n11 = byteBuf2.indexOf(byteBuf2.readerIndex(), byteBuf2.writerIndex(), (byte)-1);
        if (n11 >= 0) {
            byteBuf2.release();
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame(byteBuf2);
    }
}

