/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.codec.CorruptedFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.Utf8Validator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)object;
            if (((WebSocketFrame)object).isFinalFragment()) {
                if (!(webSocketFrame instanceof PingWebSocketFrame)) {
                    this.fragmentedFramesCount = 0;
                    if (webSocketFrame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(webSocketFrame.content());
                        this.utf8Validator.finish();
                    }
                }
            } else {
                if (this.fragmentedFramesCount == 0) {
                    if (webSocketFrame instanceof TextWebSocketFrame) {
                        this.checkUTF8String(webSocketFrame.content());
                    }
                } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                    this.checkUTF8String(webSocketFrame.content());
                }
                ++this.fragmentedFramesCount;
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    private void checkUTF8String(ByteBuf byteBuf) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(byteBuf);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof CorruptedFrameException && channelHandlerContext.channel().isOpen()) {
            channelHandlerContext.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

