/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public TextWebSocketFrame(String string) {
        super(TextWebSocketFrame.fromText(string));
    }

    public TextWebSocketFrame(ByteBuf byteBuf) {
        super(byteBuf);
    }

    public TextWebSocketFrame(boolean bl3, int n4, String string) {
        super(bl3, n4, TextWebSocketFrame.fromText(string));
    }

    private static ByteBuf fromText(String string) {
        if (string == null || string.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(string, CharsetUtil.UTF_8);
    }

    public TextWebSocketFrame(boolean bl3, int n4, ByteBuf byteBuf) {
        super(bl3, n4, byteBuf);
    }

    public String text() {
        return this.content().toString(CharsetUtil.UTF_8);
    }

    @Override
    public TextWebSocketFrame copy() {
        return (TextWebSocketFrame)super.copy();
    }

    @Override
    public TextWebSocketFrame duplicate() {
        return (TextWebSocketFrame)super.duplicate();
    }

    @Override
    public TextWebSocketFrame retainedDuplicate() {
        return (TextWebSocketFrame)super.retainedDuplicate();
    }

    @Override
    public TextWebSocketFrame replace(ByteBuf byteBuf) {
        return new TextWebSocketFrame(this.isFinalFragment(), this.rsv(), byteBuf);
    }

    @Override
    public TextWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public TextWebSocketFrame retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public TextWebSocketFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public TextWebSocketFrame touch(Object object) {
        super.touch(object);
        return this;
    }
}

