/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus) {
        this(webSocketCloseStatus.code(), webSocketCloseStatus.reasonText());
    }

    public CloseWebSocketFrame(WebSocketCloseStatus webSocketCloseStatus, String string) {
        this(webSocketCloseStatus.code(), string);
    }

    public CloseWebSocketFrame(int n4, String string) {
        this(true, 0, n4, string);
    }

    public CloseWebSocketFrame(boolean bl3, int n4) {
        this(bl3, n4, Unpooled.buffer(0));
    }

    public CloseWebSocketFrame(boolean bl3, int n4, int n7, String string) {
        super(bl3, n4, CloseWebSocketFrame.newBinaryData(n7, string));
    }

    private static ByteBuf newBinaryData(int n4, String string) {
        if (string == null) {
            string = "";
        }
        ByteBuf byteBuf = Unpooled.buffer(2 + string.length());
        byteBuf.writeShort(n4);
        if (!string.isEmpty()) {
            byteBuf.writeCharSequence(string, CharsetUtil.UTF_8);
        }
        byteBuf.readerIndex(0);
        return byteBuf;
    }

    public CloseWebSocketFrame(boolean bl3, int n4, ByteBuf byteBuf) {
        super(bl3, n4, byteBuf);
    }

    public int statusCode() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.capacity() == 0) {
            return -1;
        }
        byteBuf.readerIndex(0);
        return byteBuf.getShort(0);
    }

    public String reasonText() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.capacity() <= 2) {
            return "";
        }
        byteBuf.readerIndex(2);
        String string = byteBuf.toString(CharsetUtil.UTF_8);
        byteBuf.readerIndex(0);
        return string;
    }

    @Override
    public CloseWebSocketFrame copy() {
        return (CloseWebSocketFrame)super.copy();
    }

    @Override
    public CloseWebSocketFrame duplicate() {
        return (CloseWebSocketFrame)super.duplicate();
    }

    @Override
    public CloseWebSocketFrame retainedDuplicate() {
        return (CloseWebSocketFrame)super.retainedDuplicate();
    }

    @Override
    public CloseWebSocketFrame replace(ByteBuf byteBuf) {
        return new CloseWebSocketFrame(this.isFinalFragment(), this.rsv(), byteBuf);
    }

    @Override
    public CloseWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public CloseWebSocketFrame retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public CloseWebSocketFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public CloseWebSocketFrame touch(Object object) {
        super.touch(object);
        return this;
    }
}

