/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.List;

public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    static final int DEFAULT_DISCARD_THRESHOLD = 0xA00000;
    private final InterfaceHttpPostRequestDecoder decoder;

    public HttpPostRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.decoder = HttpPostRequestDecoder.isMultipart(httpRequest) ? new HttpPostMultipartRequestDecoder(httpDataFactory, httpRequest, charset) : new HttpPostStandardRequestDecoder(httpDataFactory, httpRequest, charset);
    }

    public static boolean isMultipart(HttpRequest httpRequest) {
        if (httpRequest.headers().contains(HttpHeaderNames.CONTENT_TYPE)) {
            return HttpPostRequestDecoder.getMultipartDataBoundary(httpRequest.headers().get(HttpHeaderNames.CONTENT_TYPE)) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String string) {
        String string2;
        String[] stringArray = HttpPostRequestDecoder.splitHeaderContentType(string);
        if (stringArray[0].regionMatches(true, 0, string2 = HttpHeaderValues.MULTIPART_FORM_DATA.toString(), 0, string2.length())) {
            String string3;
            int n4;
            String string4;
            int n7;
            int n8;
            String string5 = HttpHeaderValues.BOUNDARY.toString();
            if (stringArray[1].regionMatches(true, 0, string5, 0, string5.length())) {
                n8 = 1;
                n7 = 2;
            } else if (stringArray[2].regionMatches(true, 0, string5, 0, string5.length())) {
                n8 = 2;
                n7 = 1;
            } else {
                return null;
            }
            String string6 = StringUtil.substringAfter(stringArray[n8], '=');
            if (string6 == null) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Needs a boundary value");
            }
            if (string6.charAt(0) == '\"' && (string4 = string6.trim()).charAt(n4 = string4.length() - 1) == '\"') {
                string6 = string4.substring(1, n4);
            }
            if (stringArray[n7].regionMatches(true, 0, string4 = HttpHeaderValues.CHARSET.toString(), 0, string4.length()) && (string3 = StringUtil.substringAfter(stringArray[n7], '=')) != null) {
                return new String[]{"--" + string6, string3};
            }
            return new String[]{"--" + string6};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    @Override
    public void setDiscardThreshold(int n4) {
        this.decoder.setDiscardThreshold(n4);
    }

    @Override
    public int getDiscardThreshold() {
        return this.decoder.getDiscardThreshold();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.decoder.getBodyHttpDatas();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        return this.decoder.getBodyHttpDatas(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        return this.decoder.getBodyHttpData(string);
    }

    @Override
    public InterfaceHttpPostRequestDecoder offer(HttpContent httpContent) {
        return this.decoder.offer(httpContent);
    }

    @Override
    public boolean hasNext() {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() {
        return this.decoder.next();
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.decoder.currentPartialHttpData();
    }

    @Override
    public void destroy() {
        this.decoder.destroy();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.decoder.removeHttpDataFromClean(interfaceHttpData);
    }

    private static String[] splitHeaderContentType(String string) {
        int n4;
        int n7 = HttpPostBodyUtil.findNonWhitespace(string, 0);
        int n8 = string.indexOf(59);
        if (n8 == -1) {
            return new String[]{string, "", ""};
        }
        int n10 = HttpPostBodyUtil.findNonWhitespace(string, n8 + 1);
        if (string.charAt(n8 - 1) == ' ') {
            --n8;
        }
        if ((n4 = string.indexOf(59, n10)) == -1) {
            n4 = HttpPostBodyUtil.findEndOfString(string);
            return new String[]{string.substring(n7, n8), string.substring(n10, n4), ""};
        }
        int n11 = HttpPostBodyUtil.findNonWhitespace(string, n4 + 1);
        if (string.charAt(n4 - 1) == ' ') {
            --n4;
        }
        int n12 = HttpPostBodyUtil.findEndOfString(string);
        return new String[]{string.substring(n7, n8), string.substring(n10, n4), string.substring(n11, n12)};
    }
}

