/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.QueryStringDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.Attribute;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.FileUpload;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$TransferEncodingMechanism;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;
    private static final String FILENAME_ENCODED = HttpHeaderValues.FILENAME.toString() + '*';

    public HttpPostMultipartRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this.request = ObjectUtil.checkNotNull(httpRequest, "request");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.factory = ObjectUtil.checkNotNull(httpDataFactory, "factory");
        this.setMultipart(this.request.headers().get(HttpHeaderNames.CONTENT_TYPE));
        if (httpRequest instanceof HttpContent) {
            this.offer((HttpContent)((Object)httpRequest));
        } else {
            this.undecodedChunk = Unpooled.buffer();
            this.parseBody();
        }
    }

    private void setMultipart(String string) {
        String[] stringArray = HttpPostRequestDecoder.getMultipartDataBoundary(string);
        if (stringArray != null) {
            this.multipartDataBoundary = stringArray[0];
            if (stringArray.length > 1 && stringArray[1] != null) {
                this.charset = Charset.forName(stringArray[1]);
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int n4) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero(n4, "discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.copy();
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            this.undecodedChunk.discardReadBytes();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        InterfaceHttpData interfaceHttpData = this.decodeMultipart(this.currentStatus);
        while (interfaceHttpData != null) {
            this.addHttpData(interfaceHttpData);
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) break;
            interfaceHttpData = this.decodeMultipart(this.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus) {
        switch (httpPostRequestDecoder$MultiPartStatus) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                return this.findMultipartDelimiter(this.multipartDataBoundary, HttpPostRequestDecoder$MultiPartStatus.DISPOSITION, HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                Attribute attribute;
                Charset charset = null;
                Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (attribute2 != null) {
                    try {
                        charset = Charset.forName(attribute2.getValue());
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
                    }
                }
                Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    long l2;
                    attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        l2 = attribute != null ? Long.parseLong(attribute.getValue()) : 0L;
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        l2 = 0L;
                    }
                    try {
                        this.currentAttribute = l2 > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()), l2) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    if (charset != null) {
                        this.currentAttribute.setCharset(charset);
                    }
                }
                if (!HttpPostMultipartRequestDecoder.loadDataMultipart(this.undecodedChunk, this.multipartDataBoundary, this.currentAttribute)) {
                    return null;
                }
                attribute = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                return attribute;
            }
            case FILEUPLOAD: {
                return this.getFileUpload(this.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                return this.findMultipartDelimiter(this.multipartMixedBoundary, HttpPostRequestDecoder$MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                return this.getFileUpload(this.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Shouldn't reach here.");
    }

    private static void skipControlCharacters(ByteBuf byteBuf) {
        if (!byteBuf.hasArray()) {
            try {
                HttpPostMultipartRequestDecoder.skipControlCharactersStandard(byteBuf);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
            return;
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(byteBuf);
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            char c10;
            if (Character.isISOControl(c10 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF)) || Character.isWhitespace(c10)) continue;
            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException("Access out of bounds");
    }

    private static void skipControlCharactersStandard(ByteBuf byteBuf) {
        char c10;
        while (Character.isISOControl(c10 = (char)byteBuf.readUnsignedByte()) || Character.isWhitespace(c10)) {
        }
        byteBuf.readerIndex(byteBuf.readerIndex() - 1);
    }

    private InterfaceHttpData findMultipartDelimiter(String string, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus2) {
        String string2;
        int n4 = this.undecodedChunk.readerIndex();
        try {
            HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n4);
            return null;
        }
        this.skipOneLine();
        try {
            string2 = HttpPostMultipartRequestDecoder.readDelimiter(this.undecodedChunk, string);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n4);
            return null;
        }
        if (string2.equals(string)) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus;
            return this.decodeMultipart(httpPostRequestDecoder$MultiPartStatus);
        }
        if (string2.equals(string + "--")) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus2;
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(n4);
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        Object object;
        int n4 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Attribute attribute;
            Object object2;
            try {
                HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
                object = HttpPostMultipartRequestDecoder.readLine(this.undecodedChunk, this.charset);
            }
            catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(n4);
                return null;
            }
            String[] stringArray = HttpPostMultipartRequestDecoder.splitMultipartHeader((String)object);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase(stringArray[0])) {
                boolean bl3;
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
                    bl3 = HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase(stringArray[1]);
                } else {
                    boolean bl4 = bl3 = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase(stringArray[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase(stringArray[1]);
                }
                if (!bl3) continue;
                for (int i3 = 2; i3 < stringArray.length; ++i3) {
                    object2 = stringArray[i3].split("=", 2);
                    try {
                        attribute = this.getContentDispositionAttribute((String[])object2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(attribute.getName(), attribute);
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute2;
                try {
                    attribute2 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute2);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute3;
                try {
                    attribute3 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_LENGTH, attribute3);
                continue;
            }
            if (!HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase(stringArray[0])) continue;
            if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase(stringArray[1])) {
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
                    String string = StringUtil.substringAfter(stringArray[2], '=');
                    this.multipartMixedBoundary = "--" + string;
                    this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                    return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER);
                }
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
            }
            for (int i8 = 1; i8 < stringArray.length; ++i8) {
                String string = HttpHeaderValues.CHARSET.toString();
                if (stringArray[i8].regionMatches(true, 0, string, 0, string.length())) {
                    object2 = StringUtil.substringAfter(stringArray[i8], '=');
                    try {
                        attribute = this.factory.createAttribute(this.request, string, HttpPostMultipartRequestDecoder.cleanString((String)object2));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(HttpHeaderValues.CHARSET, attribute);
                    continue;
                }
                try {
                    object2 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(stringArray[0]), stringArray[i8]);
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(object2.getName(), (Attribute)object2);
            }
        }
        object = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            if (object != null) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FIELD);
        }
        if (object != null) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Filename not found");
    }

    private Attribute getContentDispositionAttribute(String ... stringArray) {
        String string = HttpPostMultipartRequestDecoder.cleanString(stringArray[0]);
        String string2 = stringArray[1];
        if (HttpHeaderValues.FILENAME.contentEquals(string)) {
            int n4 = string2.length() - 1;
            if (n4 > 0 && string2.charAt(0) == '\"' && string2.charAt(n4) == '\"') {
                string2 = string2.substring(1, n4);
            }
        } else if (FILENAME_ENCODED.equals(string)) {
            try {
                string = HttpHeaderValues.FILENAME.toString();
                String[] stringArray2 = string2.split("'", 3);
                string2 = QueryStringDecoder.decodeComponent(stringArray2[2], Charset.forName(stringArray2[0]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(arrayIndexOutOfBoundsException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
            }
        } else {
            string2 = HttpPostMultipartRequestDecoder.cleanString(string2);
        }
        return this.factory.createAttribute(this.request, string, string2);
    }

    protected InterfaceHttpData getFileUpload(String string) {
        HttpData httpData;
        Object object;
        Attribute attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset charset = this.charset;
        HttpPostBodyUtil$TransferEncodingMechanism httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT7;
        if (attribute != null) {
            try {
                object = attribute.getValue().toLowerCase();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT7.value())) {
                charset = CharsetUtil.US_ASCII;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT8.value())) {
                charset = CharsetUtil.ISO_8859_1;
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT8;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value())) {
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("TransferEncoding Unknown: " + (String)object);
            }
        }
        if ((object = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                charset = Charset.forName(object.getValue());
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
            }
        }
        if (this.currentFileUpload == null) {
            long l2;
            httpData = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute attribute4 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                l2 = attribute4 != null ? Long.parseLong(attribute4.getValue()) : 0L;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = 0L;
            }
            try {
                String string2 = attribute3 != null ? attribute3.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute2.getValue()), HttpPostMultipartRequestDecoder.cleanString(httpData.getValue()), string2, httpPostBodyUtil$TransferEncodingMechanism.value(), charset, l2);
            }
            catch (NullPointerException nullPointerException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
        }
        if (!HttpPostMultipartRequestDecoder.loadDataMultipart(this.undecodedChunk, string, this.currentFileUpload)) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            httpData = this.currentFileUpload;
            this.currentFileUpload = null;
            return httpData;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.checkDestroyed();
        this.cleanFiles();
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
        for (int i3 = this.bodyListHttpDataRank; i3 < this.bodyListHttpData.size(); ++i3) {
            this.bodyListHttpData.get(i3).release();
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);
        this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
    }

    private static String readLineStandard(ByteBuf byteBuf, Charset charset) {
        int n4 = byteBuf.readerIndex();
        try {
            ByteBuf byteBuf2 = Unpooled.buffer(64);
            while (byteBuf.isReadable()) {
                byte by2 = byteBuf.readByte();
                if (by2 == 13) {
                    by2 = byteBuf.getByte(byteBuf.readerIndex());
                    if (by2 == 10) {
                        byteBuf.readByte();
                        return byteBuf2.toString(charset);
                    }
                    byteBuf2.writeByte(13);
                    continue;
                }
                if (by2 == 10) {
                    return byteBuf2.toString(charset);
                }
                byteBuf2.writeByte(by2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n4);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static String readLine(ByteBuf byteBuf, Charset charset) {
        if (!byteBuf.hasArray()) {
            return HttpPostMultipartRequestDecoder.readLineStandard(byteBuf, charset);
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(byteBuf);
        int n4 = byteBuf.readerIndex();
        try {
            ByteBuf byteBuf2 = Unpooled.buffer(64);
            while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                byte by2;
                if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                        if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                            return byteBuf2.toString(charset);
                        }
                        --httpPostBodyUtil$SeekAheadOptimize.pos;
                        byteBuf2.writeByte(13);
                        continue;
                    }
                    byteBuf2.writeByte(by2);
                    continue;
                }
                if (by2 == 10) {
                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                    return byteBuf2.toString(charset);
                }
                byteBuf2.writeByte(by2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n4);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static String readDelimiterStandard(ByteBuf byteBuf, String string) {
        int n4 = byteBuf.readerIndex();
        try {
            byte by2;
            StringBuilder stringBuilder = new StringBuilder(64);
            int n7 = string.length();
            for (int i3 = 0; byteBuf.isReadable() && i3 < n7; ++i3) {
                by2 = byteBuf.readByte();
                if (by2 == string.charAt(i3)) {
                    stringBuilder.append((char)by2);
                    continue;
                }
                byteBuf.readerIndex(n4);
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            if (byteBuf.isReadable()) {
                by2 = byteBuf.readByte();
                if (by2 == 13) {
                    by2 = byteBuf.readByte();
                    if (by2 == 10) {
                        return stringBuilder.toString();
                    }
                    byteBuf.readerIndex(n4);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                }
                if (by2 == 10) {
                    return stringBuilder.toString();
                }
                if (by2 == 45) {
                    stringBuilder.append('-');
                    by2 = byteBuf.readByte();
                    if (by2 == 45) {
                        stringBuilder.append('-');
                        if (byteBuf.isReadable()) {
                            by2 = byteBuf.readByte();
                            if (by2 == 13) {
                                by2 = byteBuf.readByte();
                                if (by2 == 10) {
                                    return stringBuilder.toString();
                                }
                                byteBuf.readerIndex(n4);
                                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                            }
                            if (by2 == 10) {
                                return stringBuilder.toString();
                            }
                            byteBuf.readerIndex(byteBuf.readerIndex() - 1);
                            return stringBuilder.toString();
                        }
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n4);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static String readDelimiter(ByteBuf byteBuf, String string) {
        if (!byteBuf.hasArray()) {
            return HttpPostMultipartRequestDecoder.readDelimiterStandard(byteBuf, string);
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(byteBuf);
        int n4 = byteBuf.readerIndex();
        int n7 = string.length();
        try {
            byte by2;
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i3 = 0; httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit && i3 < n7; ++i3) {
                if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == string.charAt(i3)) {
                    stringBuilder.append((char)by2);
                    continue;
                }
                byteBuf.readerIndex(n4);
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                        if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                            return stringBuilder.toString();
                        }
                        byteBuf.readerIndex(n4);
                        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                    }
                    byteBuf.readerIndex(n4);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                }
                if (by2 == 10) {
                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                    return stringBuilder.toString();
                }
                if (by2 == 45) {
                    stringBuilder.append('-');
                    if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit && (by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 45) {
                        stringBuilder.append('-');
                        if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                            if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 13) {
                                if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                                    if ((by2 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++]) == 10) {
                                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                        return stringBuilder.toString();
                                    }
                                    byteBuf.readerIndex(n4);
                                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                                }
                                byteBuf.readerIndex(n4);
                                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                            }
                            if (by2 == 10) {
                                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                return stringBuilder.toString();
                            }
                            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
                            return stringBuilder.toString();
                        }
                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n4);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n4);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static boolean loadDataMultipartStandard(ByteBuf byteBuf, String string, HttpData httpData) {
        int n4 = byteBuf.readerIndex();
        int n7 = string.length();
        int n8 = 0;
        int n10 = n4;
        int n11 = 10;
        boolean bl3 = false;
        while (byteBuf.isReadable()) {
            byte by2 = byteBuf.readByte();
            if (n11 == 10 && by2 == string.codePointAt(n8)) {
                if (n7 != ++n8) continue;
                bl3 = true;
                break;
            }
            n10 = byteBuf.readerIndex();
            if (by2 == 10) {
                n8 = 0;
                n10 -= n11 == 13 ? 2 : 1;
            }
            n11 = by2;
        }
        if (n11 == 13) {
            --n10;
        }
        ByteBuf byteBuf2 = byteBuf.copy(n4, n10 - n4);
        try {
            httpData.addContent(byteBuf2, bl3);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        byteBuf.readerIndex(n10);
        return bl3;
    }

    private static boolean loadDataMultipart(ByteBuf byteBuf, String string, HttpData httpData) {
        int n4;
        if (!byteBuf.hasArray()) {
            return HttpPostMultipartRequestDecoder.loadDataMultipartStandard(byteBuf, string, httpData);
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(byteBuf);
        int n7 = byteBuf.readerIndex();
        int n8 = string.length();
        int n10 = 0;
        int n11 = httpPostBodyUtil$SeekAheadOptimize.pos;
        int n12 = 10;
        boolean bl3 = false;
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            n4 = httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++];
            if (n12 == 10 && n4 == string.codePointAt(n10)) {
                if (n8 != ++n10) continue;
                bl3 = true;
                break;
            }
            n11 = httpPostBodyUtil$SeekAheadOptimize.pos;
            if (n4 == 10) {
                n10 = 0;
                n11 -= n12 == 13 ? 2 : 1;
            }
            n12 = n4;
        }
        if (n12 == 13) {
            --n11;
        }
        n4 = httpPostBodyUtil$SeekAheadOptimize.getReadPosition(n11);
        ByteBuf byteBuf2 = byteBuf.copy(n7, n4 - n7);
        try {
            httpData.addContent(byteBuf2, bl3);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        byteBuf.readerIndex(n4);
        return bl3;
    }

    private static String cleanString(String string) {
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n4);
        block4: for (int i3 = 0; i3 < n4; ++i3) {
            char c10 = string.charAt(i3);
            switch (c10) {
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    stringBuilder.append(' ');
                    continue block4;
                }
                case '\"': {
                    continue block4;
                }
                default: {
                    stringBuilder.append(c10);
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    private boolean skipOneLine() {
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte by2 = this.undecodedChunk.readByte();
        if (by2 == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            by2 = this.undecodedChunk.readByte();
            if (by2 == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (by2 == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String string) {
        int n4;
        int n7;
        char c10;
        int n8;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n8 = n7 = HttpPostBodyUtil.findNonWhitespace(string, 0); n8 < string.length() && (c10 = string.charAt(n8)) != ':' && !Character.isWhitespace(c10); ++n8) {
        }
        for (n4 = n8; n4 < string.length(); ++n4) {
            if (string.charAt(n4) != ':') continue;
            ++n4;
            break;
        }
        int n10 = HttpPostBodyUtil.findNonWhitespace(string, n4);
        int n11 = HttpPostBodyUtil.findEndOfString(string);
        arrayList.add(string.substring(n7, n8));
        String string2 = n10 >= n11 ? "" : string.substring(n10, n11);
        String[] stringArray = string2.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(string2) : string2.split(",");
        for (String string3 : stringArray) {
            arrayList.add(string3.trim());
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            stringArray2[i3] = (String)arrayList.get(i3);
        }
        return stringArray2;
    }

    private static String[] splitMultipartHeaderValues(String string) {
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList(1);
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = 0;
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c10 = string.charAt(i3);
            if (bl3) {
                if (bl4) {
                    bl4 = false;
                    continue;
                }
                if (c10 == '\\') {
                    bl4 = true;
                    continue;
                }
                if (c10 != '\"') continue;
                bl3 = false;
                continue;
            }
            if (c10 == '\"') {
                bl3 = true;
                continue;
            }
            if (c10 != ';') continue;
            arrayList.add(string.substring(n4, i3));
            n4 = i3 + 1;
        }
        arrayList.add(string.substring(n4));
        return arrayList.toArray(new String[0]);
    }
}

